# Infrastructure OpenStack Test Suite

## Overview

This suite tests infrastructure on OpenStack.

## Pre-requisites

- Working CNCF Kubernetes installation (KinD/k0s/Minikube/etc...)
- KUBECONFIG file
- KCM Build uploaded to accessible registry

## Create Environment Test (test_create_env.py)

Install KCM chart into k8s cluster

- Delete (if exists) and create stack
- Store information about stack into ksi_config.yaml

### Execution

```bash
py.test $(KSI_HOME)/si_tests/infra/openstack/test_create_env.py
```

### Expected pods check

Not yet applicable.

### Variables that MUST be filled before run and have no default value

| ENV Variable                | Type    | Description                                                                                       | Example                               |
|-----------------------------|---------|---------------------------------------------------------------------------------------------------|---------------------------------------|
| `KSI_OS_CLOUD_NAME`         | `<str>` |                                                                                                   |                                       |
| `KSI_OS_APP_SECRET`         | `<str>` |                                                                                                   |                                       |
| `KSI_OS_CLOUDS_YAML_PATH`   | `<str>` |                                                                                                   | `test_env_data/ic_access/clouds.yaml` |
| `KSI_KEEP_ENV_BEFORE`       | `<str>` |                                                                                                   | True                                  |
| `KSI_ENV_CONFIG_NAME`       | `<str>` |                                                                                                   |                                       |
| `KSI_HEAT_DATA_PATH`        | `<str>` |                                                                                                   |                                       |
| `KSI_SEED_IP`               | `<str>` | seed node IP, might be overwritten or fetched from ksi_config.yaml                                |                                       |
| `KSI_INFRA_BUILD_URL`       | `<str>` | this url will be attached to openstack-heat stack(as for now), useful to trace-back orphaned envs |                                       |
| `KSI_INFRA_OS_KEYPAIR_NAME` | `<str>` | Underlay Openstack PublicKeyName, to be injected into seed\etc nodes. Keypair must be pre-created |                                       |

