# from kubernetes.client.rest import ApiException
import requests
from requests import exceptions as rexc
from retry import retry
from urllib3 import exceptions as urlexc

from si_tests import settings
from si_tests import logger

LOG = logger.logger


@retry((Exception, urlexc.MaxRetryError, urlexc.ProtocolError,
        rexc.Timeout, rexc.ConnectTimeout, rexc.ReadTimeout, rexc.ConnectionError),
       delay=15, tries=600, logger=LOG)
def get_response_from_url(url):
    resp = requests.get(url, verify=False)
    return resp


def test_ingress_services(kcm_manager, show_step):
    """Check ingress services availability

    Scenario:
        1. Access target cluster and check that cluster is Ready and accessible
        2. Test services availability via external IPs
    """

    show_step(1)
    ns = kcm_manager.get_namespace(settings.TARGET_NAMESPACE)
    cld = ns.get_cluster_deployment(settings.TARGET_CLD)
    cld.check.check_actual_expected_pods()
    # Limit readiness check since we should have already deployed working cluster
    cld.check.check_cluster_readiness(timeout=600)
    # assert clusterdeployment.k8sclient.componentstatuses.describe_fixed_resources
    LOG.info(f"Clusterdeployment {cld.namespace}/{cld.name} checked and ready.")

    show_step(2)
    cld_api = cld.k8sclient
    services = cld_api.services.list_all()
    for service in services:
        service_address = service.get_external_ip()
        if not service_address:
            continue
        service_ports = service.get_ports()
        for service_port in service_ports:
            port_name = service_port.name
            protocol = service_port.app_protocol
            port = service_port.port
            if protocol in ['http', 'https']:
                url = f"{protocol}://{service_address}:{port}"

                LOG.banner(f"Wait until service '{service.namespace}/{service.name}' become available on url '{url}'",
                           sep="-")
                resp = get_response_from_url(url)
                LOG.info(f"Service '{service.namespace}/{service.name}' response on url '{url}':\n{resp.text}")
            elif port_name in ['http', 'https']:
                url = f"{port_name}://{service_address}:{port}"

                LOG.banner(f"Wait until service '{service.namespace}/{service.name}' become available on url '{url}'",
                           sep="-")
                resp = get_response_from_url(url)
                LOG.info(f"Service '{service.namespace}/{service.name}' response on url '{url}':\n{resp.text}")
            else:
                LOG.warning(f"Service '{service.namespace}/{service.name}' "
                            f"unknown protocol '{protocol}' for port '{port}', skipping")
