from si_tests import logger
from si_tests import settings

LOG = logger.logger


def test_delete_clusterdeployment(kcm_manager, show_step):
    """Check removal of the clusterdeployment

    Scenario:
        1. Gather evnironment config
        2. Remove persistent volume claims
        3. Remove loadbalancers
        4. Remove clusterdeployment and wait for deletion
    """

    show_step(1)
    ns = kcm_manager.get_namespace(settings.TARGET_NAMESPACE)
    cld = ns.get_cluster_deployment(settings.TARGET_CLD)
    if cld.regional_object:
        raise RuntimeError(f"Cluster deployment {cld.name} have regional object "
                           f"{cld.regional_object.name} attached. Please remove all clusters belongs to it and "
                           f"region first.")

    show_step(2)
    if settings.KSI_CLEANUP_CHILD_PVCS:
        cld.check.delete_cleanup_and_check_pvcs()
    else:
        LOG.info("Skipping PVC cleanup")

    show_step(3)
    try:
        LOG.info(f"Checking for LoadBalancers in cluster {cld.namespace}/{cld.name}")
        services = cld.k8sclient.services.list_all()
        lb_services = [svc for svc in services if svc.type == 'LoadBalancer']
        if lb_services:
            LOG.info(
                f"Found {len(lb_services)} LoadBalancers in cluster {cld.namespace}/{cld.name}"
                )
            for svc in lb_services:
                LOG.info(
                    f"Removing LoadBalancers/LoadBalancer/ {svc.namespace}/{svc.name} "
                    f"from cluster {cld.namespace}/{cld.name}"
                )
                svc.delete()
        else:
            LOG.info(f"No LoadBalancers found in cluster {cld.namespace}/{cld.name}")
    except Exception as e:
        LOG.warning(f"Failed to cleanup LoadBalancers from cluster {cld.namespace}/{cld.name}: {e}")

    show_step(4)
    cld.check.delete_clusterdeployment_and_check()
    LOG.info(f"ClusterDeployment {cld.namespace}/{cld.name} successfully removed.")
