# Checks test module

## Overview
This directory contains different tests related to checking cluster readiness and various aspects of deployed clusters.

## Test Suite

- [Check cluster readiness](#test_check_cld_readinesspy)
- [Check MCS child cluster readiness](#test_check_mcs_child_readinesspy)
- [Check MCS management cluster readiness](#test_check_mcs_mgmt_readinesspy)

## Pre-requisites

- Working k0rdent kcm installation required to execute any of those tests
- Target cluster deployment must exist in the specified namespace

## Detailed description of common checks inside tests and each test separately

### Common checks

All checks verify the readiness of deployed clusters by performing the following validations:
- Check that nodes in the deployed cluster are in expected state (expected by default - Running and Ready)
- Check that we have no crashlooping pods in the deployed cluster
- Check statuses of clusterdeployment object (expected to be Ready=True as concatenation of conditions inside)

### test_check_cld_readiness.py
This test checks the readiness of a child cluster deployment.

### test_check_mcs_child_readiness.py
This test checks the readiness of a child cluster deployment and verifies MultiClusterService (MCS) services readiness for that cluster.

### test_check_mcs_mgmt_readiness.py
This test checks the readiness of the management cluster and verifies MultiClusterService (MCS) services readiness for the management cluster.

## Common variables for each test and customization of runs

| ENV Variable                         | Type     | Description                                                                            | Defaults              |
|--------------------------------------|----------|----------------------------------------------------------------------------------------|-----------------------|
| `TARGET_NAMESPACE`                   | `<str>`  | The namespace where the target clusterdeployment is located                            | `kcm-system`          |
| `TARGET_CLD`                         | `<str>`  | Name of the target clusterdeployment to check                                          | Equals to `KCM_CLUSTER_DEPLOYMENT_NAME` |
| `CHECK_CLUSTER_READINESS_TIMEOUT`    | `<int>`  | Time-to-wait for cluster deployment to become Ready                                    | 7200s (2h)            |
| `ENABLE_INTROSPECT_CAP_ERRORS`       | `<bool>` | Enable or not logging of errors inside CAPI controllers                                | `True`                |
| `SKIP_EXPECTED_POD_CHECK`            | `<bool>` | Whether or not skip expected pods check                                                | `False`               |
| `CHECK_ACTUAL_EXPECTED_PODS_TIMEOUT` | `<int>`  | Time-to-wait for all expected pods will be in place                                    | 300                   |
| `WAIT_PODS_READY_TIMEOUT`            | `<int>`  | Time-to-wait for all pods to have Ready and Running statuses                           | 1800                  |

## Target cluster deployment requirements

Before running any of the checks tests, you must ensure that:
1. A target clusterdeployment exists in the specified namespace
2. The `TARGET_NAMESPACE` and `TARGET_CLD` environment variables are properly set
3. The KCM cluster is accessible via KUBECONFIG

## Test execution examples

```shell
# Set up required environment variables
export KUBECONFIG=/path/to/kcm/kubeconfig
export TARGET_NAMESPACE=kcm-system
export TARGET_CLD=my-cluster-deployment

# Run specific check test
py.test si_tests/tests/checks/test_check_cld_readiness.py

# Run all checks tests
py.test si_tests/tests/checks/
```