import pytest

from si_tests import logger
from si_tests import settings
from si_tests.managers import k0s_manager
from si_tests.utils import utils

LOG = logger.logger


# TODO(alexz-kh): this is draft test scenario
# 1) configure seed ( network\vbmcd\auth\packages\etc)
# 2) install k0s

@pytest.mark.usefixtures('log_step_time')
@pytest.mark.usefixtures('log_method_time')
def test_install_seed(show_step):
    """Initiate seed node configuration

    Scenario:
        1. Install k0s at seed node(localhost)
    """
    show_step(1)
    # self test, to not harm random env
    utils.ksi_seed_check_fuse()
    # TODO(alexz-kh): when we will get PR tests, here might be fixes required!
    oot_capi_provider_metal3_registry = settings.KSI_BAREMETAL_CAPI_PROVIDER_METAL3_REPO_DICT['ci-registry']
    if settings.KSI_BAREMETAL_CAPI_PROVIDER_METAL3_SOURCE == 'custom-enterprise':
        assert settings.KSI_BAREMETAL_CAPI_PROVIDER_METAL3_CUSTOM_REGISTRY, (
            'KSI_BAREMETAL_CAPI_PROVIDER_METAL3_CUSTOM_REGISTRY can not be empty with '
            'KSI_BAREMETAL_CAPI_PROVIDER_METAL3_SOURCE=custom-enterprise')
        oot_capi_provider_metal3_registry = settings.KSI_BAREMETAL_CAPI_PROVIDER_METAL3_CUSTOM_REGISTRY
    bs_data = utils.render_and_save_data(template_path=settings.KSI_BOOTSTRAP_DATA_PATH,
                                         render_opts={
                                             'target_namespace': settings.KCM_NAMESPACE,
                                             'oot_capi_provider_metal3_registry': oot_capi_provider_metal3_registry
                                         })
    # ksi_config = ksi_config_manager.KSIConfigManager(ksi_config_path=settings.KSI_CONFIG_PATH)
    k0s_config = bs_data.get('bootstrap_k0s_config_raw', {})
    k0s_m = k0s_manager.K0sBotstrapManager(k0s_config=k0s_config)
    k0s_m.install_k0s_if_not()
    k0s_m.save_bootstrap_kubeconfig_to_arts()
