#    Copyright 2025 Mirantis, Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

from si_tests import settings
from si_tests import logger

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from si_tests.managers.kcm_manager import Manager

LOG = logger.logger


class Metal3Manager(object):
    """Metal3 provides components for bare metal host management"""

    def __init__(self, kcm_manager: "Manager"):
        self.kcm_manager: "Manager" = kcm_manager
        self._helmmgr = None

    @property
    def helmmgr(self):
        if not self._helmmgr:
            self._helmmgr = self.kcm_manager.helmmgr
        return self._helmmgr

    @property
    def template_path(self):
        return settings.EXPECTED_PODS_TEMPLATES_DIR + 'oot/' + 'metal3-' + self.get_capm3_chart_version() + '.yaml'

    def capm3_is_deployed(self) -> bool:
        return True if self.get_capm3_chart_status() == 'deployed' else False

    def get_capm3_chart_status(self, verbose=False):
        meta = self.get_capm3_chart_metadata()
        if not meta:
            return None
        status = meta.get('status', None)
        if verbose:
            LOG.info(f"{settings.KSI_BAREMETAL_CAPI_PROVIDER_METAL3_CHART_NAME} chart status is {status}")
        return status

    def get_capm3_chart_metadata(self):
        if self.helmmgr.is_release_present(settings.KSI_BAREMETAL_CAPI_PROVIDER_METAL3_CHART_NAME):
            return self.helmmgr.get_metadata(settings.KSI_BAREMETAL_CAPI_PROVIDER_METAL3_CHART_NAME,
                                             settings.KCM_NAMESPACE)
        else:
            return None

    def get_capm3_chart_version(self):
        return settings.KSI_BAREMETAL_CAPI_PROVIDER_METAL3_CHART_VERSION.split('-')[0].replace('.', '-')
