#    Copyright 2025 Mirantis, Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations

from si_tests.clients.k8s import base
from si_tests import logger
from si_tests.utils import waiters

LOG = logger.logger


class V1VeleroBackupStorageLocation(base.BaseModel):
    pass


class V1VeleroBackupStorageLocationList(base.BaseModelList):
    pass


class VeleroBackupStorageLocation(base.K8sNamespacedResource):
    resource_type = 'backupstoragelocation'
    model = V1VeleroBackupStorageLocation

    @property
    def phase(self):
        # Read fresh data from the cluster
        obj = self.read(cached=False)
        if obj and hasattr(obj, 'status') and obj.status:
            # status is a dict, so access it as such
            if isinstance(obj.status, dict):
                return obj.status.get('phase', 'Unknown')
            else:
                return getattr(obj.status, 'phase', 'Unknown')
        return 'Unknown'

    def available(self, verbose=True):
        res = self.phase == 'Available'
        if not res and verbose:
            LOG.warning(f"BackupStorageLocation {self.namespace}/{self.name} is not available yet. "
                        f"Current phase: {self.phase}")
        return res

    def wait_for_availability(self, timeout=300, interval=10):
        timeout_msg = f"Timeout waiting for BackupStorageLocation {self.namespace}/{self.name} to become available"
        waiters.wait(lambda: self.available(verbose=True), interval=interval, timeout=timeout,
                     timeout_msg=timeout_msg)


class VeleroBackupStorageLocationManager(base.K8sBaseManager):
    model = V1VeleroBackupStorageLocationList
    resource_class = VeleroBackupStorageLocation
    resource_group = 'velero.io'
    resource_version = 'v1'
    resource_plural = 'backupstoragelocations'
