#    Copyright 2025 Mirantis, Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations

from si_tests.clients.k8s import base
from si_tests import logger

LOG = logger.logger


class V1K0rdentManagementBackup(base.BaseModel):
    pass


class V1K0rdentManagementBackupList(base.BaseModelList):
    pass


class K0rdentManagementBackup(base.K8sClusterScopedResource):
    resource_type = 'managementbackup'
    model = V1K0rdentManagementBackup

    @property
    def ready(self):
        """Check if the backup is ready/completed"""
        phase = self.data.get('status', {}).get('lastBackup', {}).get('phase', '')
        return phase.lower() == 'completed'

    @property
    def phase(self):
        """Get the current phase of the backup status"""
        return self.data.get('status', {}).get('phase', 'Unknown')

    @property
    def last_backup_phase(self):
        """Get the phase of the last backup attempt"""
        phase = self.data.get('status', {}).get('lastBackup', {}).get('phase', 'Unknown')
        if phase.lower() == 'failedvalidation':
            validation_errors = self.data.get('status', {}).get('lastBackup', {}).get('validationErrors', [])
            error_msg = '; '.join(validation_errors) if validation_errors else 'Unknown validation error'
            raise Exception(f"Backup {self.name} failed validation: {error_msg}")
        return phase

    @property
    def storage_location(self):
        """Get the storage location of the backup"""
        return self.data.get('spec', {}).get('storageLocation', '')

    @property
    def expiration(self):
        """Get the expiration time of the backup if set"""
        return self.data.get('status', {}).get('lastBackup', {}).get('expiration', None)

    @property
    def start_timestamp(self):
        """Get the start timestamp of the backup"""
        return self.data.get('status', {}).get('lastBackup', {}).get('startTimestamp', None)

    @property
    def completion_timestamp(self):
        """Get the completion timestamp of the backup"""
        return self.data.get('status', {}).get('lastBackup', {}).get('completionTimestamp', None)


class K0rdentManagementBackupManager(base.K8sBaseManager):
    model = V1K0rdentManagementBackupList
    resource_class = K0rdentManagementBackup
    resource_group = 'k0rdent.mirantis.com'
    resource_version = 'v1beta1'
    resource_plural = 'managementbackups'
