#    Copyright 2025 Mirantis, Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations

from si_tests.clients.k8s import base


class V1MachinePool(base.BaseModel):
    pass


class V1MachinePoolList(base.BaseModelList):
    pass


class MachinePool(base.K8sNamespacedResource):
    resource_type = 'machinepool'
    model = V1MachinePool

    @property
    def spec(self):
        return self.read().spec

    @property
    def cluster_name(self):
        cluster_name = self.spec['clusterName']
        return cluster_name

    @property
    def replicas(self):
        rep = self.spec.get('replicas', None)
        return int(rep) if rep else rep


class MachinePoolManager(base.K8sBaseManager):
    model = V1MachinePoolList
    resource_class = MachinePool
    resource_group = 'cluster.x-k8s.io'
    resource_version = 'v1beta1'
    resource_plural = 'machinepools'
