#    Copyright 2025 Mirantis, Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations

from si_tests.clients.k8s import base


class V1GCPManagedMachinePool(base.BaseModel):
    pass


class V1GCPManagedMachinePoolList(base.BaseModelList):
    pass


class GCPManagedMachinePool(base.K8sNamespacedResource):
    resource_type = 'gcpmanagedmachinepool'
    model = V1GCPManagedMachinePool

    @property
    def ready(self):
        status = self.read().status
        ready = status.get('ready', None)
        return True if ready.lower() == 'true' else False

    @property
    def current_replicas(self):
        status = self.read().status
        rep = status.get('replicas', None)
        return int(rep) if rep else rep

    @property
    def desired_replicas(self):
        # NOTE(va4st): the 'replicas' field in the gcpmanagedmachinepool status represents current replicas.
        # The desired replicas (which set during cluster creation) is stored in the
        # spec section of the parent resource - MachinePool.
        """Get replicas count which was set during creation of the cluster

        :return:
        """
        mp_interface = self._manager._cluster.capi_machinepools.get(name=self.name, namespace=self.namespace)
        return mp_interface.replicas


class GCPManagedMachinePoolManager(base.K8sBaseManager):
    model = V1GCPManagedMachinePoolList
    resource_class = GCPManagedMachinePool
    resource_group = 'infrastructure.cluster.x-k8s.io'
    resource_version = 'v1beta1'
    resource_plural = 'gcpmanagedmachinepools'
