#    Copyright 2025 Mirantis, Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations

from si_tests.clients.k8s import base


class V1GCPManagedControlPlane(base.BaseModel):
    pass


class V1GCPManagedControlPlaneList(base.BaseModelList):
    pass


class GCPManagedControlPlane(base.K8sNamespacedResource):
    resource_type = 'gcpmanagedcontrolplane'
    model = V1GCPManagedControlPlane

    @property
    def ready(self):
        status = self.read().status
        ready = status.get('ready', None)
        return bool(ready) if ready else ready

    @property
    def spec_version(self):
        """The version that located exactly in the spec section of the resource.

        :return:
        """
        spec = self.read().spec
        version = spec.get('version', None)
        return version

    @property
    def current_version(self):
        """The current version that located in the status section of the resource.

        :return:
        """
        status = self.read().status
        version = status.get('currentVersion', None)
        return version


class GCPManagedControlPlaneManager(base.K8sBaseManager):
    model = V1GCPManagedControlPlaneList
    resource_class = GCPManagedControlPlane
    resource_group = 'infrastructure.cluster.x-k8s.io'
    resource_version = 'v1beta1'
    resource_plural = 'gcpmanagedcontrolplanes'
