# coding: utf-8

"""
    Inference Box API

    ## Welcome to Inference Box API  A comprehensive REST API for managing cloud infrastructure resources including ML inference deployments, Kubernetes resources, and application lifecycle management.  ## Overview  Inference Box API is a cloud-native REST API service that provides unified access to manage:  - **ML Inference Deployments**: Create, manage, and scale machine learning inference services - **Slurm Clusters**: Deploy, configure, and manage HPC Slurm clusters for batch workloads - **Kubernetes Resources**: Manage namespaces (projects), pods, secrets, volumes, and other K8s resources - **Application Lifecycle**: Deploy and manage applications from catalog templates - **Resource Management**: Handle flavors, capacities, quotas, and node groups - **User & Access Control**: Manage users, groups, and API keys with RBAC integration - **Monitoring & Metrics**: Query metrics and monitor resource usage via Victoria Metrics  The service is built with Go and integrates with Kubernetes, HashiCorp Vault, and Victoria Metrics to provide a complete cloud infrastructure management solution.  ## Key API Endpoints  - **Inference**: `/v1/{project_name}/inferences` - ML inference deployment management - **Inference (Admin)**: `/v1/admin/{project_name}/inferences` - ML inference deployment management (admin only) - **Slurm Clusters**: `/v1/{project_name}/slurm/clusters` - Slurm cluster deployment and management - **Flavors**: `/v1/flavors` - Compute resource flavor definitions - **Flavors Management**: `/v1/admin/flavors` - Compute resource flavor definitions management - **Users**: `/v1/admin/users` - User management (admin only) - **Projects**: `/v1/{project_name}` - Project-scoped resource operations - **Metrics**: `/v1/{project_name}/metrics` - Resource usage metrics  ## Getting Started  ### Authentication  All API requests require authentication using the `X-API-Key` header. Most operations are scoped to specific projects/namespaces.  ### API Organization  The API is organized into logical groups: - **Public endpoints**: `/v1/*` - General access endpoints - **Project-scoped**: `/v1/{project_name}/*` - Project-specific resources - **Admin endpoints**: `/v1/admin/*` - Administrative operations  ### Documentation  Interactive documentation is available at `/docs` when the service is running. 

    The version of the OpenAPI document: 2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import unittest

from si_tests.clients.gcore.box_api.models.v1_create_scale_triggers import V1CreateScaleTriggers

class TestV1CreateScaleTriggers(unittest.TestCase):
    """V1CreateScaleTriggers unit test stubs"""

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def make_instance(self, include_optional) -> V1CreateScaleTriggers:
        """Test V1CreateScaleTriggers
            include_optional is a boolean, when False only required
            params are included, when True both required and
            optional params are included """
        # uncomment below to create an instance of `V1CreateScaleTriggers`
        """
        model = V1CreateScaleTriggers()
        if include_optional:
            return V1CreateScaleTriggers(
                cpu = si_tests.clients.gcore.box_api.models.v1/cpu_trigger.v1.CpuTrigger(
                    threshold = 80, ),
                gpu_memory = si_tests.clients.gcore.box_api.models.v1/gpu_memory_trigger.v1.GpuMemoryTrigger(
                    threshold = 80, ),
                gpu_utilization = si_tests.clients.gcore.box_api.models.v1/gpu_utilization_trigger.v1.GpuUtilizationTrigger(
                    threshold = 80, ),
                http = si_tests.clients.gcore.box_api.models.v1/http_trigger.v1.HttpTrigger(
                    rate = 10, 
                    window = 60, ),
                memory = si_tests.clients.gcore.box_api.models.v1/memory_trigger.v1.MemoryTrigger(
                    threshold = 80, ),
                sqs = si_tests.clients.gcore.box_api.models.v1/sqs_trigger.v1.SqsTrigger(
                    activation_queue_length = 56, 
                    aws_endpoint = '', 
                    aws_region = '', 
                    queue_length = 56, 
                    queue_url = '', 
                    scale_on_delayed = True, 
                    scale_on_flight = True, 
                    secret_name = '', )
            )
        else:
            return V1CreateScaleTriggers(
        )
        """

    def testV1CreateScaleTriggers(self):
        """Test V1CreateScaleTriggers"""
        # inst_req_only = self.make_instance(include_optional=False)
        # inst_req_and_optional = self.make_instance(include_optional=True)

if __name__ == '__main__':
    unittest.main()
