# coding: utf-8

"""
    Inference Box API

    ## Welcome to Inference Box API  A comprehensive REST API for managing cloud infrastructure resources including ML inference deployments, Kubernetes resources, and application lifecycle management.  ## Overview  Inference Box API is a cloud-native REST API service that provides unified access to manage:  - **ML Inference Deployments**: Create, manage, and scale machine learning inference services - **Slurm Clusters**: Deploy, configure, and manage HPC Slurm clusters for batch workloads - **Kubernetes Resources**: Manage namespaces (projects), pods, secrets, volumes, and other K8s resources - **Application Lifecycle**: Deploy and manage applications from catalog templates - **Resource Management**: Handle flavors, capacities, quotas, and node groups - **User & Access Control**: Manage users, groups, and API keys with RBAC integration - **Monitoring & Metrics**: Query metrics and monitor resource usage via Victoria Metrics  The service is built with Go and integrates with Kubernetes, HashiCorp Vault, and Victoria Metrics to provide a complete cloud infrastructure management solution.  ## Key API Endpoints  - **Inference**: `/v1/{project_name}/inferences` - ML inference deployment management - **Inference (Admin)**: `/v1/admin/{project_name}/inferences` - ML inference deployment management (admin only) - **Slurm Clusters**: `/v1/{project_name}/slurm/clusters` - Slurm cluster deployment and management - **Flavors**: `/v1/flavors` - Compute resource flavor definitions - **Flavors Management**: `/v1/admin/flavors` - Compute resource flavor definitions management - **Users**: `/v1/admin/users` - User management (admin only) - **Projects**: `/v1/{project_name}` - Project-scoped resource operations - **Metrics**: `/v1/{project_name}/metrics` - Resource usage metrics  ## Getting Started  ### Authentication  All API requests require authentication using the `X-API-Key` header. Most operations are scoped to specific projects/namespaces.  ### API Organization  The API is organized into logical groups: - **Public endpoints**: `/v1/*` - General access endpoints - **Project-scoped**: `/v1/{project_name}/*` - Project-specific resources - **Admin endpoints**: `/v1/admin/*` - Administrative operations  ### Documentation  Interactive documentation is available at `/docs` when the service is running. 

    The version of the OpenAPI document: 2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import unittest

from si_tests.clients.gcore.box_api.api.users_api import UsersApi


class TestUsersApi(unittest.TestCase):
    """UsersApi unit test stubs"""

    def setUp(self) -> None:
        self.api = UsersApi()

    def tearDown(self) -> None:
        pass

    def test_v1_create_user(self) -> None:
        """Test case for v1_create_user

        Create user
        """
        pass

    def test_v1_delete_user(self) -> None:
        """Test case for v1_delete_user

        Delete user
        """
        pass

    def test_v1_get_user(self) -> None:
        """Test case for v1_get_user

        Get user
        """
        pass

    def test_v1_get_user_secret(self) -> None:
        """Test case for v1_get_user_secret

        Get user password
        """
        pass

    def test_v1_list_users(self) -> None:
        """Test case for v1_list_users

        List users
        """
        pass

    def test_v1_login_user(self) -> None:
        """Test case for v1_login_user

        Login user
        """
        pass

    def test_v1_refresh_user_token(self) -> None:
        """Test case for v1_refresh_user_token

        Refresh user's token
        """
        pass

    def test_v1_update_user(self) -> None:
        """Test case for v1_update_user

        Update user
        """
        pass

    def test_v1_update_user_secret(self) -> None:
        """Test case for v1_update_user_secret

        Update user password
        """
        pass

    def test_v1_who_am_i(self) -> None:
        """Test case for v1_who_am_i

        Get current user
        """
        pass


if __name__ == '__main__':
    unittest.main()
