# coding: utf-8

"""
    Inference Box API

    ## Welcome to Inference Box API  A comprehensive REST API for managing cloud infrastructure resources including ML inference deployments, Kubernetes resources, and application lifecycle management.  ## Overview  Inference Box API is a cloud-native REST API service that provides unified access to manage:  - **ML Inference Deployments**: Create, manage, and scale machine learning inference services - **Slurm Clusters**: Deploy, configure, and manage HPC Slurm clusters for batch workloads - **Kubernetes Resources**: Manage namespaces (projects), pods, secrets, volumes, and other K8s resources - **Application Lifecycle**: Deploy and manage applications from catalog templates - **Resource Management**: Handle flavors, capacities, quotas, and node groups - **User & Access Control**: Manage users, groups, and API keys with RBAC integration - **Monitoring & Metrics**: Query metrics and monitor resource usage via Victoria Metrics  The service is built with Go and integrates with Kubernetes, HashiCorp Vault, and Victoria Metrics to provide a complete cloud infrastructure management solution.  ## Key API Endpoints  - **Inference**: `/v1/{project_name}/inferences` - ML inference deployment management - **Inference (Admin)**: `/v1/admin/{project_name}/inferences` - ML inference deployment management (admin only) - **Slurm Clusters**: `/v1/{project_name}/slurm/clusters` - Slurm cluster deployment and management - **Flavors**: `/v1/flavors` - Compute resource flavor definitions - **Flavors Management**: `/v1/admin/flavors` - Compute resource flavor definitions management - **Users**: `/v1/admin/users` - User management (admin only) - **Projects**: `/v1/{project_name}` - Project-scoped resource operations - **Metrics**: `/v1/{project_name}/metrics` - Resource usage metrics  ## Getting Started  ### Authentication  All API requests require authentication using the `X-API-Key` header. Most operations are scoped to specific projects/namespaces.  ### API Organization  The API is organized into logical groups: - **Public endpoints**: `/v1/*` - General access endpoints - **Project-scoped**: `/v1/{project_name}/*` - Project-specific resources - **Admin endpoints**: `/v1/admin/*` - Administrative operations  ### Documentation  Interactive documentation is available at `/docs` when the service is running. 

    The version of the OpenAPI document: 2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from si_tests.clients.gcore.box_api.models.schemas_component_configuration import SchemasComponentConfiguration
from si_tests.clients.gcore.box_api.models.schemas_status import SchemasStatus
from typing import Optional, Set
from typing_extensions import Self

class SchemasAppDeployment(BaseModel):
    """
    SchemasAppDeployment
    """ # noqa: E501
    api_keys: Optional[List[StrictStr]] = Field(default=None, description="ApiKeys is a list of API keys which will be applied to each component of the application")
    application_name: Optional[StrictStr] = Field(default=None, description="ApplicationName is the identifier of application from catalog")
    components_configuration: Optional[Dict[str, SchemasComponentConfiguration]] = Field(default=None, description="ComponentsConfiguration defines the configuration of individual components in the deployment.")
    created_at: Optional[StrictStr] = Field(default=None, description="CreatedAt is the time when the application deployment was created")
    name: Optional[StrictStr] = Field(default=None, description="Name is the unique identifier of deployment")
    paused: Optional[StrictBool] = Field(default=None, description="Paused indicates state of resource self-updating")
    regions: Optional[List[StrictStr]] = Field(default=None, description="Regions list the geographical regions where the deployment is active.")
    status: Optional[SchemasStatus] = None
    __properties: ClassVar[List[str]] = ["api_keys", "application_name", "components_configuration", "created_at", "name", "paused", "regions", "status"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SchemasAppDeployment from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in components_configuration (dict)
        _field_dict = {}
        if self.components_configuration:
            for _key_components_configuration in self.components_configuration:
                if self.components_configuration[_key_components_configuration]:
                    _field_dict[_key_components_configuration] = self.components_configuration[_key_components_configuration].to_dict()
            _dict['components_configuration'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of status
        if self.status:
            _dict['status'] = self.status.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SchemasAppDeployment from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "api_keys": obj.get("api_keys"),
            "application_name": obj.get("application_name"),
            "components_configuration": dict(
                (_k, SchemasComponentConfiguration.from_dict(_v))
                for _k, _v in obj["components_configuration"].items()
            )
            if obj.get("components_configuration") is not None
            else None,
            "created_at": obj.get("created_at"),
            "name": obj.get("name"),
            "paused": obj.get("paused"),
            "regions": obj.get("regions"),
            "status": SchemasStatus.from_dict(obj["status"]) if obj.get("status") is not None else None
        })
        return _obj


