# coding: utf-8

# flake8: noqa
"""
    Inference Box API

    ## Welcome to Inference Box API  A comprehensive REST API for managing cloud infrastructure resources including ML inference deployments, Kubernetes resources, and application lifecycle management.  ## Overview  Inference Box API is a cloud-native REST API service that provides unified access to manage:  - **ML Inference Deployments**: Create, manage, and scale machine learning inference services - **Slurm Clusters**: Deploy, configure, and manage HPC Slurm clusters for batch workloads - **Kubernetes Resources**: Manage namespaces (projects), pods, secrets, volumes, and other K8s resources - **Application Lifecycle**: Deploy and manage applications from catalog templates - **Resource Management**: Handle flavors, capacities, quotas, and node groups - **User & Access Control**: Manage users, groups, and API keys with RBAC integration - **Monitoring & Metrics**: Query metrics and monitor resource usage via Victoria Metrics  The service is built with Go and integrates with Kubernetes, HashiCorp Vault, and Victoria Metrics to provide a complete cloud infrastructure management solution.  ## Key API Endpoints  - **Inference**: `/v1/{project_name}/inferences` - ML inference deployment management - **Inference (Admin)**: `/v1/admin/{project_name}/inferences` - ML inference deployment management (admin only) - **Slurm Clusters**: `/v1/{project_name}/slurm/clusters` - Slurm cluster deployment and management - **Flavors**: `/v1/flavors` - Compute resource flavor definitions - **Flavors Management**: `/v1/admin/flavors` - Compute resource flavor definitions management - **Users**: `/v1/admin/users` - User management (admin only) - **Projects**: `/v1/{project_name}` - Project-scoped resource operations - **Metrics**: `/v1/{project_name}/metrics` - Resource usage metrics  ## Getting Started  ### Authentication  All API requests require authentication using the `X-API-Key` header. Most operations are scoped to specific projects/namespaces.  ### API Organization  The API is organized into logical groups: - **Public endpoints**: `/v1/*` - General access endpoints - **Project-scoped**: `/v1/{project_name}/*` - Project-specific resources - **Admin endpoints**: `/v1/admin/*` - Administrative operations  ### Documentation  Interactive documentation is available at `/docs` when the service is running. 

    The version of the OpenAPI document: 2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


if __import__("typing").TYPE_CHECKING:
    # import models into model package
    from si_tests.clients.gcore.box_api.models.api_error_response import ApiErrorResponse
    from si_tests.clients.gcore.box_api.models.api_services_apikeys_v1_public_rate_limit_response import ApiServicesApikeysV1PublicRateLimitResponse
    from si_tests.clients.gcore.box_api.models.api_services_apikeys_v1_update_public_rate_limit_request import ApiServicesApikeysV1UpdatePublicRateLimitRequest
    from si_tests.clients.gcore.box_api.models.api_services_autodiscoveries_v1_list_nodes_response import ApiServicesAutodiscoveriesV1ListNodesResponse
    from si_tests.clients.gcore.box_api.models.api_services_autodiscoveries_v1_node_response import ApiServicesAutodiscoveriesV1NodeResponse
    from si_tests.clients.gcore.box_api.models.api_services_defaultquotas_v1_create_quota_request import ApiServicesDefaultquotasV1CreateQuotaRequest
    from si_tests.clients.gcore.box_api.models.api_services_defaultquotas_v1_quota_response import ApiServicesDefaultquotasV1QuotaResponse
    from si_tests.clients.gcore.box_api.models.api_services_inference_v1_flavor import ApiServicesInferenceV1Flavor
    from si_tests.clients.gcore.box_api.models.api_services_inference_v1_volume import ApiServicesInferenceV1Volume
    from si_tests.clients.gcore.box_api.models.api_services_nodegroups_v1_list_nodes_response import ApiServicesNodegroupsV1ListNodesResponse
    from si_tests.clients.gcore.box_api.models.api_services_nodegroups_v1_node_response import ApiServicesNodegroupsV1NodeResponse
    from si_tests.clients.gcore.box_api.models.api_services_overview_v1_pod import ApiServicesOverviewV1Pod
    from si_tests.clients.gcore.box_api.models.api_services_overview_v1_preheat_policy import ApiServicesOverviewV1PreheatPolicy
    from si_tests.clients.gcore.box_api.models.api_services_overview_v1_preheat_policy_filters import ApiServicesOverviewV1PreheatPolicyFilters
    from si_tests.clients.gcore.box_api.models.api_services_overview_v1_preheat_policy_trigger import ApiServicesOverviewV1PreheatPolicyTrigger
    from si_tests.clients.gcore.box_api.models.api_services_overview_v1_region import ApiServicesOverviewV1Region
    from si_tests.clients.gcore.box_api.models.api_services_overview_v1_registry_response import ApiServicesOverviewV1RegistryResponse
    from si_tests.clients.gcore.box_api.models.api_services_pods_v1_pod import ApiServicesPodsV1Pod
    from si_tests.clients.gcore.box_api.models.api_services_projects_v1_public_rate_limit_response import ApiServicesProjectsV1PublicRateLimitResponse
    from si_tests.clients.gcore.box_api.models.api_services_projects_v1_update_public_rate_limit_request import ApiServicesProjectsV1UpdatePublicRateLimitRequest
    from si_tests.clients.gcore.box_api.models.api_services_quotas_v1_create_quota_request import ApiServicesQuotasV1CreateQuotaRequest
    from si_tests.clients.gcore.box_api.models.api_services_quotas_v1_quota_response import ApiServicesQuotasV1QuotaResponse
    from si_tests.clients.gcore.box_api.models.api_services_registries_v1_preheat_policy import ApiServicesRegistriesV1PreheatPolicy
    from si_tests.clients.gcore.box_api.models.api_services_registries_v1_preheat_policy_filters import ApiServicesRegistriesV1PreheatPolicyFilters
    from si_tests.clients.gcore.box_api.models.api_services_registries_v1_preheat_policy_trigger import ApiServicesRegistriesV1PreheatPolicyTrigger
    from si_tests.clients.gcore.box_api.models.api_services_registries_v1_registry_response import ApiServicesRegistriesV1RegistryResponse
    from si_tests.clients.gcore.box_api.models.api_services_secrets_v1_secret_response import ApiServicesSecretsV1SecretResponse
    from si_tests.clients.gcore.box_api.models.api_services_users_v1_secret_response import ApiServicesUsersV1SecretResponse
    from si_tests.clients.gcore.box_api.models.api_util_references_object_reference import ApiUtilReferencesObjectReference
    from si_tests.clients.gcore.box_api.models.api_validation_error_response import ApiValidationErrorResponse
    from si_tests.clients.gcore.box_api.models.autodiscovery_region_type import AutodiscoveryRegionType
    from si_tests.clients.gcore.box_api.models.schemas_app import SchemasApp
    from si_tests.clients.gcore.box_api.models.schemas_app_component import SchemasAppComponent
    from si_tests.clients.gcore.box_api.models.schemas_app_deployment import SchemasAppDeployment
    from si_tests.clients.gcore.box_api.models.schemas_app_deployment_create_request import SchemasAppDeploymentCreateRequest
    from si_tests.clients.gcore.box_api.models.schemas_app_deployment_list import SchemasAppDeploymentList
    from si_tests.clients.gcore.box_api.models.schemas_app_deployment_patch_request import SchemasAppDeploymentPatchRequest
    from si_tests.clients.gcore.box_api.models.schemas_app_inference import SchemasAppInference
    from si_tests.clients.gcore.box_api.models.schemas_app_list_response import SchemasAppListResponse
    from si_tests.clients.gcore.box_api.models.schemas_component_configuration import SchemasComponentConfiguration
    from si_tests.clients.gcore.box_api.models.schemas_component_configuration_patch import SchemasComponentConfigurationPatch
    from si_tests.clients.gcore.box_api.models.schemas_component_status import SchemasComponentStatus
    from si_tests.clients.gcore.box_api.models.schemas_expose_address import SchemasExposeAddress
    from si_tests.clients.gcore.box_api.models.schemas_parameter import SchemasParameter
    from si_tests.clients.gcore.box_api.models.schemas_parameter_override import SchemasParameterOverride
    from si_tests.clients.gcore.box_api.models.schemas_parameter_type import SchemasParameterType
    from si_tests.clients.gcore.box_api.models.schemas_region_status import SchemasRegionStatus
    from si_tests.clients.gcore.box_api.models.schemas_scale import SchemasScale
    from si_tests.clients.gcore.box_api.models.schemas_scale_patch import SchemasScalePatch
    from si_tests.clients.gcore.box_api.models.schemas_short_flavor import SchemasShortFlavor
    from si_tests.clients.gcore.box_api.models.schemas_status import SchemasStatus
    from si_tests.clients.gcore.box_api.models.v1_access_rule import V1AccessRule
    from si_tests.clients.gcore.box_api.models.v1_action_requests import V1ActionRequests
    from si_tests.clients.gcore.box_api.models.v1_api_key_rate_limits_response import V1ApiKeyRateLimitsResponse
    from si_tests.clients.gcore.box_api.models.v1_api_key_response import V1ApiKeyResponse
    from si_tests.clients.gcore.box_api.models.v1_audit_log_response import V1AuditLogResponse
    from si_tests.clients.gcore.box_api.models.v1_audit_logs_response import V1AuditLogsResponse
    from si_tests.clients.gcore.box_api.models.v1_batch_deschedule_pod_request import V1BatchDeschedulePodRequest
    from si_tests.clients.gcore.box_api.models.v1_cluster import V1Cluster
    from si_tests.clients.gcore.box_api.models.v1_container_probe import V1ContainerProbe
    from si_tests.clients.gcore.box_api.models.v1_cpu_trigger import V1CpuTrigger
    from si_tests.clients.gcore.box_api.models.v1_create_api_key_request import V1CreateApiKeyRequest
    from si_tests.clients.gcore.box_api.models.v1_create_api_key_response import V1CreateApiKeyResponse
    from si_tests.clients.gcore.box_api.models.v1_create_flavor_request import V1CreateFlavorRequest
    from si_tests.clients.gcore.box_api.models.v1_create_group_request import V1CreateGroupRequest
    from si_tests.clients.gcore.box_api.models.v1_create_inference_request import V1CreateInferenceRequest
    from si_tests.clients.gcore.box_api.models.v1_create_instance_request import V1CreateInstanceRequest
    from si_tests.clients.gcore.box_api.models.v1_create_instance_response import V1CreateInstanceResponse
    from si_tests.clients.gcore.box_api.models.v1_create_namespace_request import V1CreateNamespaceRequest
    from si_tests.clients.gcore.box_api.models.v1_create_node_group_request import V1CreateNodeGroupRequest
    from si_tests.clients.gcore.box_api.models.v1_create_project_request import V1CreateProjectRequest
    from si_tests.clients.gcore.box_api.models.v1_create_pull_secret_request import V1CreatePullSecretRequest
    from si_tests.clients.gcore.box_api.models.v1_create_registry_request import V1CreateRegistryRequest
    from si_tests.clients.gcore.box_api.models.v1_create_registry_user_request import V1CreateRegistryUserRequest
    from si_tests.clients.gcore.box_api.models.v1_create_scale_request import V1CreateScaleRequest
    from si_tests.clients.gcore.box_api.models.v1_create_scale_triggers import V1CreateScaleTriggers
    from si_tests.clients.gcore.box_api.models.v1_create_secret_request import V1CreateSecretRequest
    from si_tests.clients.gcore.box_api.models.v1_create_slurm_cluster_login_config import V1CreateSlurmClusterLoginConfig
    from si_tests.clients.gcore.box_api.models.v1_create_slurm_cluster_request import V1CreateSlurmClusterRequest
    from si_tests.clients.gcore.box_api.models.v1_create_slurm_cluster_worker_config import V1CreateSlurmClusterWorkerConfig
    from si_tests.clients.gcore.box_api.models.v1_create_sub_region_request import V1CreateSubRegionRequest
    from si_tests.clients.gcore.box_api.models.v1_create_tls_secret_request import V1CreateTlsSecretRequest
    from si_tests.clients.gcore.box_api.models.v1_create_user_request import V1CreateUserRequest
    from si_tests.clients.gcore.box_api.models.v1_create_volume_request import V1CreateVolumeRequest
    from si_tests.clients.gcore.box_api.models.v1_deployment_status import V1DeploymentStatus
    from si_tests.clients.gcore.box_api.models.v1_deployment_strategy_spec import V1DeploymentStrategySpec
    from si_tests.clients.gcore.box_api.models.v1_deschedule_pod_request import V1DeschedulePodRequest
    from si_tests.clients.gcore.box_api.models.v1_empty_dir_volume_source import V1EmptyDirVolumeSource
    from si_tests.clients.gcore.box_api.models.v1_exec_probe import V1ExecProbe
    from si_tests.clients.gcore.box_api.models.v1_flavor_ref import V1FlavorRef
    from si_tests.clients.gcore.box_api.models.v1_flavor_response import V1FlavorResponse
    from si_tests.clients.gcore.box_api.models.v1_get_instance_response import V1GetInstanceResponse
    from si_tests.clients.gcore.box_api.models.v1_get_metrics_for_pod_response import V1GetMetricsForPodResponse
    from si_tests.clients.gcore.box_api.models.v1_get_pods_metrics_response import V1GetPodsMetricsResponse
    from si_tests.clients.gcore.box_api.models.v1_gpu_memory_trigger import V1GpuMemoryTrigger
    from si_tests.clients.gcore.box_api.models.v1_gpu_utilization_trigger import V1GpuUtilizationTrigger
    from si_tests.clients.gcore.box_api.models.v1_group_response import V1GroupResponse
    from si_tests.clients.gcore.box_api.models.v1_http_get_probe import V1HttpGetProbe
    from si_tests.clients.gcore.box_api.models.v1_http_trigger import V1HttpTrigger
    from si_tests.clients.gcore.box_api.models.v1_image_response import V1ImageResponse
    from si_tests.clients.gcore.box_api.models.v1_image_volume_source import V1ImageVolumeSource
    from si_tests.clients.gcore.box_api.models.v1_inference_api_key_secret_response import V1InferenceAPIKeySecretResponse
    from si_tests.clients.gcore.box_api.models.v1_inference_log import V1InferenceLog
    from si_tests.clients.gcore.box_api.models.v1_inference_logs_response import V1InferenceLogsResponse
    from si_tests.clients.gcore.box_api.models.v1_inference_response import V1InferenceResponse
    from si_tests.clients.gcore.box_api.models.v1_ingress_opts import V1IngressOpts
    from si_tests.clients.gcore.box_api.models.v1_list_api_keys_response import V1ListApiKeysResponse
    from si_tests.clients.gcore.box_api.models.v1_list_flavor_response import V1ListFlavorResponse
    from si_tests.clients.gcore.box_api.models.v1_list_group_response import V1ListGroupResponse
    from si_tests.clients.gcore.box_api.models.v1_list_images_response import V1ListImagesResponse
    from si_tests.clients.gcore.box_api.models.v1_list_inference_response import V1ListInferenceResponse
    from si_tests.clients.gcore.box_api.models.v1_list_instance_response import V1ListInstanceResponse
    from si_tests.clients.gcore.box_api.models.v1_list_namespace_response import V1ListNamespaceResponse
    from si_tests.clients.gcore.box_api.models.v1_list_node_group_response import V1ListNodeGroupResponse
    from si_tests.clients.gcore.box_api.models.v1_list_pods_response import V1ListPodsResponse
    from si_tests.clients.gcore.box_api.models.v1_list_project_response import V1ListProjectResponse
    from si_tests.clients.gcore.box_api.models.v1_list_pull_secret_response import V1ListPullSecretResponse
    from si_tests.clients.gcore.box_api.models.v1_list_quotas_response import V1ListQuotasResponse
    from si_tests.clients.gcore.box_api.models.v1_list_region_response import V1ListRegionResponse
    from si_tests.clients.gcore.box_api.models.v1_list_registry_response import V1ListRegistryResponse
    from si_tests.clients.gcore.box_api.models.v1_list_registry_user_response import V1ListRegistryUserResponse
    from si_tests.clients.gcore.box_api.models.v1_list_secret_response import V1ListSecretResponse
    from si_tests.clients.gcore.box_api.models.v1_list_slurm_clusters_response import V1ListSlurmClustersResponse
    from si_tests.clients.gcore.box_api.models.v1_list_storage_classes_response import V1ListStorageClassesResponse
    from si_tests.clients.gcore.box_api.models.v1_list_sub_region_response import V1ListSubRegionResponse
    from si_tests.clients.gcore.box_api.models.v1_list_tls_secret_response import V1ListTlsSecretResponse
    from si_tests.clients.gcore.box_api.models.v1_list_user_response import V1ListUserResponse
    from si_tests.clients.gcore.box_api.models.v1_list_volumes_response import V1ListVolumesResponse
    from si_tests.clients.gcore.box_api.models.v1_logging import V1Logging
    from si_tests.clients.gcore.box_api.models.v1_login_response import V1LoginResponse
    from si_tests.clients.gcore.box_api.models.v1_login_user_request import V1LoginUserRequest
    from si_tests.clients.gcore.box_api.models.v1_memory_trigger import V1MemoryTrigger
    from si_tests.clients.gcore.box_api.models.v1_metrics_query_data import V1MetricsQueryData
    from si_tests.clients.gcore.box_api.models.v1_metrics_query_response import V1MetricsQueryResponse
    from si_tests.clients.gcore.box_api.models.v1_namespace_response import V1NamespaceResponse
    from si_tests.clients.gcore.box_api.models.v1_network_spec import V1NetworkSpec
    from si_tests.clients.gcore.box_api.models.v1_node import V1Node
    from si_tests.clients.gcore.box_api.models.v1_node_group_response import V1NodeGroupResponse
    from si_tests.clients.gcore.box_api.models.v1_node_list_response import V1NodeListResponse
    from si_tests.clients.gcore.box_api.models.v1_nodes_per_region import V1NodesPerRegion
    from si_tests.clients.gcore.box_api.models.v1_overview_response import V1OverviewResponse
    from si_tests.clients.gcore.box_api.models.v1_pvc_volume_source import V1PVCVolumeSource
    from si_tests.clients.gcore.box_api.models.v1_patch_api_key_request import V1PatchApiKeyRequest
    from si_tests.clients.gcore.box_api.models.v1_patch_slurm_cluster_request import V1PatchSlurmClusterRequest
    from si_tests.clients.gcore.box_api.models.v1_patch_slurm_cluster_worker_config import V1PatchSlurmClusterWorkerConfig
    from si_tests.clients.gcore.box_api.models.v1_probe_configuration import V1ProbeConfiguration
    from si_tests.clients.gcore.box_api.models.v1_probes import V1Probes
    from si_tests.clients.gcore.box_api.models.v1_project_rate_limits_response import V1ProjectRateLimitsResponse
    from si_tests.clients.gcore.box_api.models.v1_project_response import V1ProjectResponse
    from si_tests.clients.gcore.box_api.models.v1_pull_secret_response import V1PullSecretResponse
    from si_tests.clients.gcore.box_api.models.v1_refresh_request import V1RefreshRequest
    from si_tests.clients.gcore.box_api.models.v1_region_response import V1RegionResponse
    from si_tests.clients.gcore.box_api.models.v1_regional_volume_status import V1RegionalVolumeStatus
    from si_tests.clients.gcore.box_api.models.v1_registry_image_ref import V1RegistryImageRef
    from si_tests.clients.gcore.box_api.models.v1_registry_ref import V1RegistryRef
    from si_tests.clients.gcore.box_api.models.v1_registry_user_ref import V1RegistryUserRef
    from si_tests.clients.gcore.box_api.models.v1_registry_user_response import V1RegistryUserResponse
    from si_tests.clients.gcore.box_api.models.v1_replace_quota_request import V1ReplaceQuotaRequest
    from si_tests.clients.gcore.box_api.models.v1_resource_types_response import V1ResourceTypesResponse
    from si_tests.clients.gcore.box_api.models.v1_scale import V1Scale
    from si_tests.clients.gcore.box_api.models.v1_slurm_cluster_login_config import V1SlurmClusterLoginConfig
    from si_tests.clients.gcore.box_api.models.v1_slurm_cluster_response import V1SlurmClusterResponse
    from si_tests.clients.gcore.box_api.models.v1_slurm_cluster_worker_config import V1SlurmClusterWorkerConfig
    from si_tests.clients.gcore.box_api.models.v1_sqs_trigger import V1SqsTrigger
    from si_tests.clients.gcore.box_api.models.v1_status import V1Status
    from si_tests.clients.gcore.box_api.models.v1_storage_class_response import V1StorageClassResponse
    from si_tests.clients.gcore.box_api.models.v1_sub_region_response import V1SubRegionResponse
    from si_tests.clients.gcore.box_api.models.v1_tcp_socket_probe import V1TcpSocketProbe
    from si_tests.clients.gcore.box_api.models.v1_tls_secret_response import V1TlsSecretResponse
    from si_tests.clients.gcore.box_api.models.v1_triggers_response import V1TriggersResponse
    from si_tests.clients.gcore.box_api.models.v1_update_api_key_rate_limits_request import V1UpdateApiKeyRateLimitsRequest
    from si_tests.clients.gcore.box_api.models.v1_update_api_key_request import V1UpdateApiKeyRequest
    from si_tests.clients.gcore.box_api.models.v1_update_group_request import V1UpdateGroupRequest
    from si_tests.clients.gcore.box_api.models.v1_update_inference_request import V1UpdateInferenceRequest
    from si_tests.clients.gcore.box_api.models.v1_update_instance_request import V1UpdateInstanceRequest
    from si_tests.clients.gcore.box_api.models.v1_update_instance_response import V1UpdateInstanceResponse
    from si_tests.clients.gcore.box_api.models.v1_update_node_group_request import V1UpdateNodeGroupRequest
    from si_tests.clients.gcore.box_api.models.v1_update_project_rate_limits_request import V1UpdateProjectRateLimitsRequest
    from si_tests.clients.gcore.box_api.models.v1_update_pull_secret_request import V1UpdatePullSecretRequest
    from si_tests.clients.gcore.box_api.models.v1_update_quota_request import V1UpdateQuotaRequest
    from si_tests.clients.gcore.box_api.models.v1_update_registry_request import V1UpdateRegistryRequest
    from si_tests.clients.gcore.box_api.models.v1_update_registry_user_request import V1UpdateRegistryUserRequest
    from si_tests.clients.gcore.box_api.models.v1_update_secret_request import V1UpdateSecretRequest
    from si_tests.clients.gcore.box_api.models.v1_update_sub_region_request import V1UpdateSubRegionRequest
    from si_tests.clients.gcore.box_api.models.v1_update_tls_secret_request import V1UpdateTlsSecretRequest
    from si_tests.clients.gcore.box_api.models.v1_update_user_request import V1UpdateUserRequest
    from si_tests.clients.gcore.box_api.models.v1_update_user_secret_request import V1UpdateUserSecretRequest
    from si_tests.clients.gcore.box_api.models.v1_update_volume_request import V1UpdateVolumeRequest
    from si_tests.clients.gcore.box_api.models.v1_user_response import V1UserResponse
    from si_tests.clients.gcore.box_api.models.v1_user_update_quota_request import V1UserUpdateQuotaRequest
    from si_tests.clients.gcore.box_api.models.v1_volume_response import V1VolumeResponse
    
else:
    from lazy_imports import LazyModule, as_package, load

    load(
        LazyModule(
            *as_package(__file__),
            """# import models into model package
from si_tests.clients.gcore.box_api.models.api_error_response import ApiErrorResponse
from si_tests.clients.gcore.box_api.models.api_services_apikeys_v1_public_rate_limit_response import ApiServicesApikeysV1PublicRateLimitResponse
from si_tests.clients.gcore.box_api.models.api_services_apikeys_v1_update_public_rate_limit_request import ApiServicesApikeysV1UpdatePublicRateLimitRequest
from si_tests.clients.gcore.box_api.models.api_services_autodiscoveries_v1_list_nodes_response import ApiServicesAutodiscoveriesV1ListNodesResponse
from si_tests.clients.gcore.box_api.models.api_services_autodiscoveries_v1_node_response import ApiServicesAutodiscoveriesV1NodeResponse
from si_tests.clients.gcore.box_api.models.api_services_defaultquotas_v1_create_quota_request import ApiServicesDefaultquotasV1CreateQuotaRequest
from si_tests.clients.gcore.box_api.models.api_services_defaultquotas_v1_quota_response import ApiServicesDefaultquotasV1QuotaResponse
from si_tests.clients.gcore.box_api.models.api_services_inference_v1_flavor import ApiServicesInferenceV1Flavor
from si_tests.clients.gcore.box_api.models.api_services_inference_v1_volume import ApiServicesInferenceV1Volume
from si_tests.clients.gcore.box_api.models.api_services_nodegroups_v1_list_nodes_response import ApiServicesNodegroupsV1ListNodesResponse
from si_tests.clients.gcore.box_api.models.api_services_nodegroups_v1_node_response import ApiServicesNodegroupsV1NodeResponse
from si_tests.clients.gcore.box_api.models.api_services_overview_v1_pod import ApiServicesOverviewV1Pod
from si_tests.clients.gcore.box_api.models.api_services_overview_v1_preheat_policy import ApiServicesOverviewV1PreheatPolicy
from si_tests.clients.gcore.box_api.models.api_services_overview_v1_preheat_policy_filters import ApiServicesOverviewV1PreheatPolicyFilters
from si_tests.clients.gcore.box_api.models.api_services_overview_v1_preheat_policy_trigger import ApiServicesOverviewV1PreheatPolicyTrigger
from si_tests.clients.gcore.box_api.models.api_services_overview_v1_region import ApiServicesOverviewV1Region
from si_tests.clients.gcore.box_api.models.api_services_overview_v1_registry_response import ApiServicesOverviewV1RegistryResponse
from si_tests.clients.gcore.box_api.models.api_services_pods_v1_pod import ApiServicesPodsV1Pod
from si_tests.clients.gcore.box_api.models.api_services_projects_v1_public_rate_limit_response import ApiServicesProjectsV1PublicRateLimitResponse
from si_tests.clients.gcore.box_api.models.api_services_projects_v1_update_public_rate_limit_request import ApiServicesProjectsV1UpdatePublicRateLimitRequest
from si_tests.clients.gcore.box_api.models.api_services_quotas_v1_create_quota_request import ApiServicesQuotasV1CreateQuotaRequest
from si_tests.clients.gcore.box_api.models.api_services_quotas_v1_quota_response import ApiServicesQuotasV1QuotaResponse
from si_tests.clients.gcore.box_api.models.api_services_registries_v1_preheat_policy import ApiServicesRegistriesV1PreheatPolicy
from si_tests.clients.gcore.box_api.models.api_services_registries_v1_preheat_policy_filters import ApiServicesRegistriesV1PreheatPolicyFilters
from si_tests.clients.gcore.box_api.models.api_services_registries_v1_preheat_policy_trigger import ApiServicesRegistriesV1PreheatPolicyTrigger
from si_tests.clients.gcore.box_api.models.api_services_registries_v1_registry_response import ApiServicesRegistriesV1RegistryResponse
from si_tests.clients.gcore.box_api.models.api_services_secrets_v1_secret_response import ApiServicesSecretsV1SecretResponse
from si_tests.clients.gcore.box_api.models.api_services_users_v1_secret_response import ApiServicesUsersV1SecretResponse
from si_tests.clients.gcore.box_api.models.api_util_references_object_reference import ApiUtilReferencesObjectReference
from si_tests.clients.gcore.box_api.models.api_validation_error_response import ApiValidationErrorResponse
from si_tests.clients.gcore.box_api.models.autodiscovery_region_type import AutodiscoveryRegionType
from si_tests.clients.gcore.box_api.models.schemas_app import SchemasApp
from si_tests.clients.gcore.box_api.models.schemas_app_component import SchemasAppComponent
from si_tests.clients.gcore.box_api.models.schemas_app_deployment import SchemasAppDeployment
from si_tests.clients.gcore.box_api.models.schemas_app_deployment_create_request import SchemasAppDeploymentCreateRequest
from si_tests.clients.gcore.box_api.models.schemas_app_deployment_list import SchemasAppDeploymentList
from si_tests.clients.gcore.box_api.models.schemas_app_deployment_patch_request import SchemasAppDeploymentPatchRequest
from si_tests.clients.gcore.box_api.models.schemas_app_inference import SchemasAppInference
from si_tests.clients.gcore.box_api.models.schemas_app_list_response import SchemasAppListResponse
from si_tests.clients.gcore.box_api.models.schemas_component_configuration import SchemasComponentConfiguration
from si_tests.clients.gcore.box_api.models.schemas_component_configuration_patch import SchemasComponentConfigurationPatch
from si_tests.clients.gcore.box_api.models.schemas_component_status import SchemasComponentStatus
from si_tests.clients.gcore.box_api.models.schemas_expose_address import SchemasExposeAddress
from si_tests.clients.gcore.box_api.models.schemas_parameter import SchemasParameter
from si_tests.clients.gcore.box_api.models.schemas_parameter_override import SchemasParameterOverride
from si_tests.clients.gcore.box_api.models.schemas_parameter_type import SchemasParameterType
from si_tests.clients.gcore.box_api.models.schemas_region_status import SchemasRegionStatus
from si_tests.clients.gcore.box_api.models.schemas_scale import SchemasScale
from si_tests.clients.gcore.box_api.models.schemas_scale_patch import SchemasScalePatch
from si_tests.clients.gcore.box_api.models.schemas_short_flavor import SchemasShortFlavor
from si_tests.clients.gcore.box_api.models.schemas_status import SchemasStatus
from si_tests.clients.gcore.box_api.models.v1_access_rule import V1AccessRule
from si_tests.clients.gcore.box_api.models.v1_action_requests import V1ActionRequests
from si_tests.clients.gcore.box_api.models.v1_api_key_rate_limits_response import V1ApiKeyRateLimitsResponse
from si_tests.clients.gcore.box_api.models.v1_api_key_response import V1ApiKeyResponse
from si_tests.clients.gcore.box_api.models.v1_audit_log_response import V1AuditLogResponse
from si_tests.clients.gcore.box_api.models.v1_audit_logs_response import V1AuditLogsResponse
from si_tests.clients.gcore.box_api.models.v1_batch_deschedule_pod_request import V1BatchDeschedulePodRequest
from si_tests.clients.gcore.box_api.models.v1_cluster import V1Cluster
from si_tests.clients.gcore.box_api.models.v1_container_probe import V1ContainerProbe
from si_tests.clients.gcore.box_api.models.v1_cpu_trigger import V1CpuTrigger
from si_tests.clients.gcore.box_api.models.v1_create_api_key_request import V1CreateApiKeyRequest
from si_tests.clients.gcore.box_api.models.v1_create_api_key_response import V1CreateApiKeyResponse
from si_tests.clients.gcore.box_api.models.v1_create_flavor_request import V1CreateFlavorRequest
from si_tests.clients.gcore.box_api.models.v1_create_group_request import V1CreateGroupRequest
from si_tests.clients.gcore.box_api.models.v1_create_inference_request import V1CreateInferenceRequest
from si_tests.clients.gcore.box_api.models.v1_create_instance_request import V1CreateInstanceRequest
from si_tests.clients.gcore.box_api.models.v1_create_instance_response import V1CreateInstanceResponse
from si_tests.clients.gcore.box_api.models.v1_create_namespace_request import V1CreateNamespaceRequest
from si_tests.clients.gcore.box_api.models.v1_create_node_group_request import V1CreateNodeGroupRequest
from si_tests.clients.gcore.box_api.models.v1_create_project_request import V1CreateProjectRequest
from si_tests.clients.gcore.box_api.models.v1_create_pull_secret_request import V1CreatePullSecretRequest
from si_tests.clients.gcore.box_api.models.v1_create_registry_request import V1CreateRegistryRequest
from si_tests.clients.gcore.box_api.models.v1_create_registry_user_request import V1CreateRegistryUserRequest
from si_tests.clients.gcore.box_api.models.v1_create_scale_request import V1CreateScaleRequest
from si_tests.clients.gcore.box_api.models.v1_create_scale_triggers import V1CreateScaleTriggers
from si_tests.clients.gcore.box_api.models.v1_create_secret_request import V1CreateSecretRequest
from si_tests.clients.gcore.box_api.models.v1_create_slurm_cluster_login_config import V1CreateSlurmClusterLoginConfig
from si_tests.clients.gcore.box_api.models.v1_create_slurm_cluster_request import V1CreateSlurmClusterRequest
from si_tests.clients.gcore.box_api.models.v1_create_slurm_cluster_worker_config import V1CreateSlurmClusterWorkerConfig
from si_tests.clients.gcore.box_api.models.v1_create_sub_region_request import V1CreateSubRegionRequest
from si_tests.clients.gcore.box_api.models.v1_create_tls_secret_request import V1CreateTlsSecretRequest
from si_tests.clients.gcore.box_api.models.v1_create_user_request import V1CreateUserRequest
from si_tests.clients.gcore.box_api.models.v1_create_volume_request import V1CreateVolumeRequest
from si_tests.clients.gcore.box_api.models.v1_deployment_status import V1DeploymentStatus
from si_tests.clients.gcore.box_api.models.v1_deployment_strategy_spec import V1DeploymentStrategySpec
from si_tests.clients.gcore.box_api.models.v1_deschedule_pod_request import V1DeschedulePodRequest
from si_tests.clients.gcore.box_api.models.v1_empty_dir_volume_source import V1EmptyDirVolumeSource
from si_tests.clients.gcore.box_api.models.v1_exec_probe import V1ExecProbe
from si_tests.clients.gcore.box_api.models.v1_flavor_ref import V1FlavorRef
from si_tests.clients.gcore.box_api.models.v1_flavor_response import V1FlavorResponse
from si_tests.clients.gcore.box_api.models.v1_get_instance_response import V1GetInstanceResponse
from si_tests.clients.gcore.box_api.models.v1_get_metrics_for_pod_response import V1GetMetricsForPodResponse
from si_tests.clients.gcore.box_api.models.v1_get_pods_metrics_response import V1GetPodsMetricsResponse
from si_tests.clients.gcore.box_api.models.v1_gpu_memory_trigger import V1GpuMemoryTrigger
from si_tests.clients.gcore.box_api.models.v1_gpu_utilization_trigger import V1GpuUtilizationTrigger
from si_tests.clients.gcore.box_api.models.v1_group_response import V1GroupResponse
from si_tests.clients.gcore.box_api.models.v1_http_get_probe import V1HttpGetProbe
from si_tests.clients.gcore.box_api.models.v1_http_trigger import V1HttpTrigger
from si_tests.clients.gcore.box_api.models.v1_image_response import V1ImageResponse
from si_tests.clients.gcore.box_api.models.v1_image_volume_source import V1ImageVolumeSource
from si_tests.clients.gcore.box_api.models.v1_inference_api_key_secret_response import V1InferenceAPIKeySecretResponse
from si_tests.clients.gcore.box_api.models.v1_inference_log import V1InferenceLog
from si_tests.clients.gcore.box_api.models.v1_inference_logs_response import V1InferenceLogsResponse
from si_tests.clients.gcore.box_api.models.v1_inference_response import V1InferenceResponse
from si_tests.clients.gcore.box_api.models.v1_ingress_opts import V1IngressOpts
from si_tests.clients.gcore.box_api.models.v1_list_api_keys_response import V1ListApiKeysResponse
from si_tests.clients.gcore.box_api.models.v1_list_flavor_response import V1ListFlavorResponse
from si_tests.clients.gcore.box_api.models.v1_list_group_response import V1ListGroupResponse
from si_tests.clients.gcore.box_api.models.v1_list_images_response import V1ListImagesResponse
from si_tests.clients.gcore.box_api.models.v1_list_inference_response import V1ListInferenceResponse
from si_tests.clients.gcore.box_api.models.v1_list_instance_response import V1ListInstanceResponse
from si_tests.clients.gcore.box_api.models.v1_list_namespace_response import V1ListNamespaceResponse
from si_tests.clients.gcore.box_api.models.v1_list_node_group_response import V1ListNodeGroupResponse
from si_tests.clients.gcore.box_api.models.v1_list_pods_response import V1ListPodsResponse
from si_tests.clients.gcore.box_api.models.v1_list_project_response import V1ListProjectResponse
from si_tests.clients.gcore.box_api.models.v1_list_pull_secret_response import V1ListPullSecretResponse
from si_tests.clients.gcore.box_api.models.v1_list_quotas_response import V1ListQuotasResponse
from si_tests.clients.gcore.box_api.models.v1_list_region_response import V1ListRegionResponse
from si_tests.clients.gcore.box_api.models.v1_list_registry_response import V1ListRegistryResponse
from si_tests.clients.gcore.box_api.models.v1_list_registry_user_response import V1ListRegistryUserResponse
from si_tests.clients.gcore.box_api.models.v1_list_secret_response import V1ListSecretResponse
from si_tests.clients.gcore.box_api.models.v1_list_slurm_clusters_response import V1ListSlurmClustersResponse
from si_tests.clients.gcore.box_api.models.v1_list_storage_classes_response import V1ListStorageClassesResponse
from si_tests.clients.gcore.box_api.models.v1_list_sub_region_response import V1ListSubRegionResponse
from si_tests.clients.gcore.box_api.models.v1_list_tls_secret_response import V1ListTlsSecretResponse
from si_tests.clients.gcore.box_api.models.v1_list_user_response import V1ListUserResponse
from si_tests.clients.gcore.box_api.models.v1_list_volumes_response import V1ListVolumesResponse
from si_tests.clients.gcore.box_api.models.v1_logging import V1Logging
from si_tests.clients.gcore.box_api.models.v1_login_response import V1LoginResponse
from si_tests.clients.gcore.box_api.models.v1_login_user_request import V1LoginUserRequest
from si_tests.clients.gcore.box_api.models.v1_memory_trigger import V1MemoryTrigger
from si_tests.clients.gcore.box_api.models.v1_metrics_query_data import V1MetricsQueryData
from si_tests.clients.gcore.box_api.models.v1_metrics_query_response import V1MetricsQueryResponse
from si_tests.clients.gcore.box_api.models.v1_namespace_response import V1NamespaceResponse
from si_tests.clients.gcore.box_api.models.v1_network_spec import V1NetworkSpec
from si_tests.clients.gcore.box_api.models.v1_node import V1Node
from si_tests.clients.gcore.box_api.models.v1_node_group_response import V1NodeGroupResponse
from si_tests.clients.gcore.box_api.models.v1_node_list_response import V1NodeListResponse
from si_tests.clients.gcore.box_api.models.v1_nodes_per_region import V1NodesPerRegion
from si_tests.clients.gcore.box_api.models.v1_overview_response import V1OverviewResponse
from si_tests.clients.gcore.box_api.models.v1_pvc_volume_source import V1PVCVolumeSource
from si_tests.clients.gcore.box_api.models.v1_patch_api_key_request import V1PatchApiKeyRequest
from si_tests.clients.gcore.box_api.models.v1_patch_slurm_cluster_request import V1PatchSlurmClusterRequest
from si_tests.clients.gcore.box_api.models.v1_patch_slurm_cluster_worker_config import V1PatchSlurmClusterWorkerConfig
from si_tests.clients.gcore.box_api.models.v1_probe_configuration import V1ProbeConfiguration
from si_tests.clients.gcore.box_api.models.v1_probes import V1Probes
from si_tests.clients.gcore.box_api.models.v1_project_rate_limits_response import V1ProjectRateLimitsResponse
from si_tests.clients.gcore.box_api.models.v1_project_response import V1ProjectResponse
from si_tests.clients.gcore.box_api.models.v1_pull_secret_response import V1PullSecretResponse
from si_tests.clients.gcore.box_api.models.v1_refresh_request import V1RefreshRequest
from si_tests.clients.gcore.box_api.models.v1_region_response import V1RegionResponse
from si_tests.clients.gcore.box_api.models.v1_regional_volume_status import V1RegionalVolumeStatus
from si_tests.clients.gcore.box_api.models.v1_registry_image_ref import V1RegistryImageRef
from si_tests.clients.gcore.box_api.models.v1_registry_ref import V1RegistryRef
from si_tests.clients.gcore.box_api.models.v1_registry_user_ref import V1RegistryUserRef
from si_tests.clients.gcore.box_api.models.v1_registry_user_response import V1RegistryUserResponse
from si_tests.clients.gcore.box_api.models.v1_replace_quota_request import V1ReplaceQuotaRequest
from si_tests.clients.gcore.box_api.models.v1_resource_types_response import V1ResourceTypesResponse
from si_tests.clients.gcore.box_api.models.v1_scale import V1Scale
from si_tests.clients.gcore.box_api.models.v1_slurm_cluster_login_config import V1SlurmClusterLoginConfig
from si_tests.clients.gcore.box_api.models.v1_slurm_cluster_response import V1SlurmClusterResponse
from si_tests.clients.gcore.box_api.models.v1_slurm_cluster_worker_config import V1SlurmClusterWorkerConfig
from si_tests.clients.gcore.box_api.models.v1_sqs_trigger import V1SqsTrigger
from si_tests.clients.gcore.box_api.models.v1_status import V1Status
from si_tests.clients.gcore.box_api.models.v1_storage_class_response import V1StorageClassResponse
from si_tests.clients.gcore.box_api.models.v1_sub_region_response import V1SubRegionResponse
from si_tests.clients.gcore.box_api.models.v1_tcp_socket_probe import V1TcpSocketProbe
from si_tests.clients.gcore.box_api.models.v1_tls_secret_response import V1TlsSecretResponse
from si_tests.clients.gcore.box_api.models.v1_triggers_response import V1TriggersResponse
from si_tests.clients.gcore.box_api.models.v1_update_api_key_rate_limits_request import V1UpdateApiKeyRateLimitsRequest
from si_tests.clients.gcore.box_api.models.v1_update_api_key_request import V1UpdateApiKeyRequest
from si_tests.clients.gcore.box_api.models.v1_update_group_request import V1UpdateGroupRequest
from si_tests.clients.gcore.box_api.models.v1_update_inference_request import V1UpdateInferenceRequest
from si_tests.clients.gcore.box_api.models.v1_update_instance_request import V1UpdateInstanceRequest
from si_tests.clients.gcore.box_api.models.v1_update_instance_response import V1UpdateInstanceResponse
from si_tests.clients.gcore.box_api.models.v1_update_node_group_request import V1UpdateNodeGroupRequest
from si_tests.clients.gcore.box_api.models.v1_update_project_rate_limits_request import V1UpdateProjectRateLimitsRequest
from si_tests.clients.gcore.box_api.models.v1_update_pull_secret_request import V1UpdatePullSecretRequest
from si_tests.clients.gcore.box_api.models.v1_update_quota_request import V1UpdateQuotaRequest
from si_tests.clients.gcore.box_api.models.v1_update_registry_request import V1UpdateRegistryRequest
from si_tests.clients.gcore.box_api.models.v1_update_registry_user_request import V1UpdateRegistryUserRequest
from si_tests.clients.gcore.box_api.models.v1_update_secret_request import V1UpdateSecretRequest
from si_tests.clients.gcore.box_api.models.v1_update_sub_region_request import V1UpdateSubRegionRequest
from si_tests.clients.gcore.box_api.models.v1_update_tls_secret_request import V1UpdateTlsSecretRequest
from si_tests.clients.gcore.box_api.models.v1_update_user_request import V1UpdateUserRequest
from si_tests.clients.gcore.box_api.models.v1_update_user_secret_request import V1UpdateUserSecretRequest
from si_tests.clients.gcore.box_api.models.v1_update_volume_request import V1UpdateVolumeRequest
from si_tests.clients.gcore.box_api.models.v1_user_response import V1UserResponse
from si_tests.clients.gcore.box_api.models.v1_user_update_quota_request import V1UserUpdateQuotaRequest
from si_tests.clients.gcore.box_api.models.v1_volume_response import V1VolumeResponse

""",
            name=__name__,
            doc=__doc__,
        )
    )
