# V1CreateInstanceResponse


## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**flavor_name** | **str** | Flavor represents the hardware configuration (CPU, RAM) allocated to the JupyterLab instance. | 
**name** | **str** | Name represents the unique identifier of the JupyterLab instance. | 
**project_name** | **str** | ProjectName represents the project to which the JupyterLab instance belongs. | 
**region_name** | **str** | RegionName represents the geographic location where the JupyterLab instance is hosted. | 
**state** | **str** | State represents the current status of the JupyterLab instance (e.g., ready, deploying, disabled) | 
**token** | **str** | Token represents the access token for the JupyterLab instance | 
**url** | **str** | URL represents the HTTP address to access and use the JupyterLab instance | 
**volume_name** | **str** | VolumeName represents the attached storage volume for the JupyterLab instance. | 

## Example

```python
from si_tests.clients.gcore.box_api.models.v1_create_instance_response import V1CreateInstanceResponse

# TODO update the JSON string below
json = "{}"
# create an instance of V1CreateInstanceResponse from a JSON string
v1_create_instance_response_instance = V1CreateInstanceResponse.from_json(json)
# print the JSON string representation of the object
print(V1CreateInstanceResponse.to_json())

# convert the object into a dict
v1_create_instance_response_dict = v1_create_instance_response_instance.to_dict()
# create an instance of V1CreateInstanceResponse from a dict
v1_create_instance_response_from_dict = V1CreateInstanceResponse.from_dict(v1_create_instance_response_dict)
```
[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)


