# si_tests.clients.gcore.box_api.UsersApi

All URIs are relative to *http://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**v1_create_user**](UsersApi.md#v1_create_user) | **POST** /v1/admin/users | Create user
[**v1_delete_user**](UsersApi.md#v1_delete_user) | **DELETE** /v1/admin/users/{user_name} | Delete user
[**v1_get_user**](UsersApi.md#v1_get_user) | **GET** /v1/admin/users/{user_name} | Get user
[**v1_get_user_secret**](UsersApi.md#v1_get_user_secret) | **GET** /v1/admin/users/{user_name}/secret | Get user password
[**v1_list_users**](UsersApi.md#v1_list_users) | **GET** /v1/admin/users | List users
[**v1_login_user**](UsersApi.md#v1_login_user) | **POST** /v1/login | Login user
[**v1_refresh_user_token**](UsersApi.md#v1_refresh_user_token) | **POST** /v1/refresh | Refresh user&#39;s token
[**v1_update_user**](UsersApi.md#v1_update_user) | **PUT** /v1/admin/users/{user_name} | Update user
[**v1_update_user_secret**](UsersApi.md#v1_update_user_secret) | **PUT** /v1/admin/users/{user_name}/secret | Update user password
[**v1_who_am_i**](UsersApi.md#v1_who_am_i) | **GET** /v1/users/me | Get current user


# **v1_create_user**
> V1UserResponse v1_create_user(v1_create_user_request)

Create user

This endpoint creates a new user with the specified properties.

When creating a user, you can define:
- Basic information (name, email)
- Group memberships
- Access rules for different projects
- Whether the user has superuser privileges

Use this endpoint when you need to:
- Add a new user to the system
- Create accounts for team members or customers
- Set up users with specific access permissions

Note: After creating a user, you'll need to:
1. Retrieve the user's password using the GET /v1/admin/users/{user_name}/secret endpoint
2. Use the password to obtain an authentication token via POST /v1/login
3. Use the token for subsequent API calls

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_create_user_request import V1CreateUserRequest
from si_tests.clients.gcore.box_api.models.v1_user_response import V1UserResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.UsersApi(api_client)
    v1_create_user_request = si_tests.clients.gcore.box_api.V1CreateUserRequest() # V1CreateUserRequest | User body

    try:
        # Create user
        api_response = api_instance.v1_create_user(v1_create_user_request)
        print("The response of UsersApi->v1_create_user:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling UsersApi->v1_create_user: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **v1_create_user_request** | [**V1CreateUserRequest**](V1CreateUserRequest.md)| User body | 

### Return type

[**V1UserResponse**](V1UserResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_delete_user**
> v1_delete_user(user_name)

Delete user

This endpoint removes a user from the system.

When a user is deleted:
- The user's access to the system is immediately revoked
- The user will no longer appear in the list of available users
- Any resources owned exclusively by the user may need to be reassigned

Use this endpoint when you need to:
- Remove a user who no longer requires access to the system
- Clean up user accounts for departed employees or inactive customers

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.UsersApi(api_client)
    user_name = 'user_name_example' # str | User name

    try:
        # Delete user
        api_instance.v1_delete_user(user_name)
    except Exception as e:
        print("Exception when calling UsersApi->v1_delete_user: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_name** | **str**| User name | 

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_get_user**
> V1UserResponse v1_get_user(user_name)

Get user

This endpoint retrieves detailed information about a specific user by name.

The response includes:
- The user's name and email
- Group memberships
- Access rules for different projects
- Whether the user has superuser privileges
- When the user was created

Use this endpoint when you need to:
- Examine the configuration of a particular user
- Verify a user's access permissions
- Get detailed information about a user for administrative purposes

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_user_response import V1UserResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.UsersApi(api_client)
    user_name = 'user_name_example' # str | User name

    try:
        # Get user
        api_response = api_instance.v1_get_user(user_name)
        print("The response of UsersApi->v1_get_user:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling UsersApi->v1_get_user: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_name** | **str**| User name | 

### Return type

[**V1UserResponse**](V1UserResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_get_user_secret**
> ApiServicesUsersV1SecretResponse v1_get_user_secret(user_name)

Get user password

This endpoint retrieves the password for a specific user.

Use this endpoint when you need to:
- Retrieve a user's password for administrative purposes
- Provide password information to the user through a secure channel
- Get the password for a newly created user to complete the authentication flow

Note: This endpoint is a crucial part of the user creation process:
1. After creating a user with POST /v1/admin/users
2. Use this endpoint to retrieve the user's password
3. Use the password to obtain an authentication token via POST /v1/login

This endpoint should be used with caution and only by authorized administrators.
The password should never be displayed or stored in an insecure manner.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.api_services_users_v1_secret_response import ApiServicesUsersV1SecretResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.UsersApi(api_client)
    user_name = 'user_name_example' # str | User name

    try:
        # Get user password
        api_response = api_instance.v1_get_user_secret(user_name)
        print("The response of UsersApi->v1_get_user_secret:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling UsersApi->v1_get_user_secret: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_name** | **str**| User name | 

### Return type

[**ApiServicesUsersV1SecretResponse**](ApiServicesUsersV1SecretResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_list_users**
> V1ListUserResponse v1_list_users()

List users

This endpoint retrieves a list of all users in the system.

Users are individuals who can access the system with specific permissions.
Use this endpoint to get an overview of all registered users and their configurations.
This information is useful for user management and access control planning.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_list_user_response import V1ListUserResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.UsersApi(api_client)

    try:
        # List users
        api_response = api_instance.v1_list_users()
        print("The response of UsersApi->v1_list_users:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling UsersApi->v1_list_users: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**V1ListUserResponse**](V1ListUserResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_login_user**
> V1LoginResponse v1_login_user(v1_login_user_request)

Login user

This endpoint authenticates a user and returns an access token.

The token returned by this endpoint can be used to authenticate subsequent API requests.
Include the token in the `Authorization` header of your requests using the Bearer scheme: `Authorization: Bearer your_token`.

Note: This endpoint is a crucial part of the user creation process:
1. After creating a user with POST /v1/admin/users
2. Retrieve the user's password using GET /v1/admin/users/{user_name}/secret
3. Use this endpoint to obtain an authentication token and refresh token to be able to refresh the token later

Be aware that user tokens expire after 5 minutes of inactivity.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_login_response import V1LoginResponse
from si_tests.clients.gcore.box_api.models.v1_login_user_request import V1LoginUserRequest
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.UsersApi(api_client)
    v1_login_user_request = si_tests.clients.gcore.box_api.V1LoginUserRequest() # V1LoginUserRequest | Login user request

    try:
        # Login user
        api_response = api_instance.v1_login_user(v1_login_user_request)
        print("The response of UsersApi->v1_login_user:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling UsersApi->v1_login_user: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **v1_login_user_request** | [**V1LoginUserRequest**](V1LoginUserRequest.md)| Login user request | 

### Return type

[**V1LoginResponse**](V1LoginResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_refresh_user_token**
> V1LoginResponse v1_refresh_user_token(v1_refresh_request)

Refresh user's token

This endpoint refresh users token and returns an access token and new refresh token.

The token returned by this endpoint can be used to authenticate subsequent API requests.

Be aware that user tokens expire after 5 minutes of inactivity. User are able to refresh their token using this endpoint.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_login_response import V1LoginResponse
from si_tests.clients.gcore.box_api.models.v1_refresh_request import V1RefreshRequest
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.UsersApi(api_client)
    v1_refresh_request = si_tests.clients.gcore.box_api.V1RefreshRequest() # V1RefreshRequest | Login user request

    try:
        # Refresh user's token
        api_response = api_instance.v1_refresh_user_token(v1_refresh_request)
        print("The response of UsersApi->v1_refresh_user_token:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling UsersApi->v1_refresh_user_token: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **v1_refresh_request** | [**V1RefreshRequest**](V1RefreshRequest.md)| Login user request | 

### Return type

[**V1LoginResponse**](V1LoginResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_update_user**
> V1UserResponse v1_update_user(user_name, v1_update_user_request)

Update user

This endpoint updates an existing user's properties.

You can modify:
- The user's email
- Group memberships
- Access rules for different projects
- Whether the user has superuser privileges

Use this endpoint when you need to:
- Change a user's contact information
- Modify a user's access permissions
- Add or remove a user from groups
- Grant or revoke superuser privileges

Note: The user name cannot be changed.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_update_user_request import V1UpdateUserRequest
from si_tests.clients.gcore.box_api.models.v1_user_response import V1UserResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.UsersApi(api_client)
    user_name = 'user_name_example' # str | User name
    v1_update_user_request = si_tests.clients.gcore.box_api.V1UpdateUserRequest() # V1UpdateUserRequest | User body

    try:
        # Update user
        api_response = api_instance.v1_update_user(user_name, v1_update_user_request)
        print("The response of UsersApi->v1_update_user:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling UsersApi->v1_update_user: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_name** | **str**| User name | 
 **v1_update_user_request** | [**V1UpdateUserRequest**](V1UpdateUserRequest.md)| User body | 

### Return type

[**V1UserResponse**](V1UserResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_update_user_secret**
> v1_update_user_secret(user_name, v1_update_user_secret_request)

Update user password

This endpoint updates the password for a specific user.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_update_user_secret_request import V1UpdateUserSecretRequest
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.UsersApi(api_client)
    user_name = 'user_name_example' # str | User name
    v1_update_user_secret_request = si_tests.clients.gcore.box_api.V1UpdateUserSecretRequest() # V1UpdateUserSecretRequest | User secret body

    try:
        # Update user password
        api_instance.v1_update_user_secret(user_name, v1_update_user_secret_request)
    except Exception as e:
        print("Exception when calling UsersApi->v1_update_user_secret: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_name** | **str**| User name | 
 **v1_update_user_secret_request** | [**V1UpdateUserSecretRequest**](V1UpdateUserSecretRequest.md)| User secret body | 

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_who_am_i**
> V1UserResponse v1_who_am_i()

Get current user

This endpoint retrieves information about the currently authenticated user.

The response includes:
- The user's name and email
- Group memberships
- Access rules for different projects
- Whether the user has superuser privileges
- When the user was created

Use this endpoint when you need to:
- Display user profile information
- Verify the current user's permissions
- Customize the UI based on the user's access level

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_user_response import V1UserResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.UsersApi(api_client)

    try:
        # Get current user
        api_response = api_instance.v1_who_am_i()
        print("The response of UsersApi->v1_who_am_i:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling UsersApi->v1_who_am_i: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**V1UserResponse**](V1UserResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

