# SchemasStatus

Status represents the current state of the deployment across regions.

## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**component_inferences** | [**Dict[str, SchemasAppInference]**](SchemasAppInference.md) | ComponentInferences contains a map of a component and its inference | [optional] 
**consolidated_status** | **str** | ConsolidatedStatus provides a high-level summary of the deployment status across all regions. | [optional] 
**expose_addresses** | [**Dict[str, SchemasExposeAddress]**](SchemasExposeAddress.md) | ExposeAddresses contains a map of a component key to | [optional] 
**regions** | [**Dict[str, SchemasRegionStatus]**](SchemasRegionStatus.md) | Regions contain status details for each region where the application is deployed. | [optional] 

## Example

```python
from si_tests.clients.gcore.box_api.models.schemas_status import SchemasStatus

# TODO update the JSON string below
json = "{}"
# create an instance of SchemasStatus from a JSON string
schemas_status_instance = SchemasStatus.from_json(json)
# print the JSON string representation of the object
print(SchemasStatus.to_json())

# convert the object into a dict
schemas_status_dict = schemas_status_instance.to_dict()
# create an instance of SchemasStatus from a dict
schemas_status_from_dict = SchemasStatus.from_dict(schemas_status_dict)
```
[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)


