# SchemasAppDeployment


## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**api_keys** | **List[str]** | ApiKeys is a list of API keys which will be applied to each component of the application | [optional] 
**application_name** | **str** | ApplicationName is the identifier of application from catalog | [optional] 
**components_configuration** | [**Dict[str, SchemasComponentConfiguration]**](SchemasComponentConfiguration.md) | ComponentsConfiguration defines the configuration of individual components in the deployment. | [optional] 
**created_at** | **str** | CreatedAt is the time when the application deployment was created | [optional] 
**name** | **str** | Name is the unique identifier of deployment | [optional] 
**paused** | **bool** | Paused indicates state of resource self-updating | [optional] 
**regions** | **List[str]** | Regions list the geographical regions where the deployment is active. | [optional] 
**status** | [**SchemasStatus**](SchemasStatus.md) |  | [optional] 

## Example

```python
from si_tests.clients.gcore.box_api.models.schemas_app_deployment import SchemasAppDeployment

# TODO update the JSON string below
json = "{}"
# create an instance of SchemasAppDeployment from a JSON string
schemas_app_deployment_instance = SchemasAppDeployment.from_json(json)
# print the JSON string representation of the object
print(SchemasAppDeployment.to_json())

# convert the object into a dict
schemas_app_deployment_dict = schemas_app_deployment_instance.to_dict()
# create an instance of SchemasAppDeployment from a dict
schemas_app_deployment_from_dict = SchemasAppDeployment.from_dict(schemas_app_deployment_dict)
```
[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)


