# si_tests.clients.gcore.box_api.PullSecretsApi

All URIs are relative to *http://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**v1_create_pull_secret**](PullSecretsApi.md#v1_create_pull_secret) | **POST** /v1/{project_name}/pullsecrets | Create pull secret
[**v1_delete_pull_secret**](PullSecretsApi.md#v1_delete_pull_secret) | **DELETE** /v1/{project_name}/pullsecrets/{pullsecret_name} | Delete pull secret
[**v1_get_pull_secret**](PullSecretsApi.md#v1_get_pull_secret) | **GET** /v1/{project_name}/pullsecrets/{pullsecret_name} | Get pull secret
[**v1_list_pull_secrets**](PullSecretsApi.md#v1_list_pull_secrets) | **GET** /v1/{project_name}/pullsecrets | List pull secrets
[**v1_update_pull_secret**](PullSecretsApi.md#v1_update_pull_secret) | **PUT** /v1/{project_name}/pullsecrets/{pullsecret_name} | Update pull secret


# **v1_create_pull_secret**
> V1PullSecretResponse v1_create_pull_secret(project_name, v1_create_pull_secret_request)

Create pull secret

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_create_pull_secret_request import V1CreatePullSecretRequest
from si_tests.clients.gcore.box_api.models.v1_pull_secret_response import V1PullSecretResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.PullSecretsApi(api_client)
    project_name = 'project_name_example' # str | Project name
    v1_create_pull_secret_request = si_tests.clients.gcore.box_api.V1CreatePullSecretRequest() # V1CreatePullSecretRequest | PullSecret body

    try:
        # Create pull secret
        api_response = api_instance.v1_create_pull_secret(project_name, v1_create_pull_secret_request)
        print("The response of PullSecretsApi->v1_create_pull_secret:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PullSecretsApi->v1_create_pull_secret: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 
 **v1_create_pull_secret_request** | [**V1CreatePullSecretRequest**](V1CreatePullSecretRequest.md)| PullSecret body | 

### Return type

[**V1PullSecretResponse**](V1PullSecretResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_delete_pull_secret**
> v1_delete_pull_secret(project_name, pullsecret_name)

Delete pull secret

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.PullSecretsApi(api_client)
    project_name = 'project_name_example' # str | Project name
    pullsecret_name = 'pullsecret_name_example' # str | PullSecret name

    try:
        # Delete pull secret
        api_instance.v1_delete_pull_secret(project_name, pullsecret_name)
    except Exception as e:
        print("Exception when calling PullSecretsApi->v1_delete_pull_secret: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 
 **pullsecret_name** | **str**| PullSecret name | 

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_get_pull_secret**
> V1PullSecretResponse v1_get_pull_secret(project_name, pullsecret_name)

Get pull secret

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_pull_secret_response import V1PullSecretResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.PullSecretsApi(api_client)
    project_name = 'project_name_example' # str | Project name
    pullsecret_name = 'pullsecret_name_example' # str | PullSecret name

    try:
        # Get pull secret
        api_response = api_instance.v1_get_pull_secret(project_name, pullsecret_name)
        print("The response of PullSecretsApi->v1_get_pull_secret:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PullSecretsApi->v1_get_pull_secret: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 
 **pullsecret_name** | **str**| PullSecret name | 

### Return type

[**V1PullSecretResponse**](V1PullSecretResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_list_pull_secrets**
> V1ListPullSecretResponse v1_list_pull_secrets(project_name)

List pull secrets

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_list_pull_secret_response import V1ListPullSecretResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.PullSecretsApi(api_client)
    project_name = 'project_name_example' # str | Project name

    try:
        # List pull secrets
        api_response = api_instance.v1_list_pull_secrets(project_name)
        print("The response of PullSecretsApi->v1_list_pull_secrets:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PullSecretsApi->v1_list_pull_secrets: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 

### Return type

[**V1ListPullSecretResponse**](V1ListPullSecretResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_update_pull_secret**
> V1PullSecretResponse v1_update_pull_secret(project_name, pullsecret_name, v1_update_pull_secret_request)

Update pull secret

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_pull_secret_response import V1PullSecretResponse
from si_tests.clients.gcore.box_api.models.v1_update_pull_secret_request import V1UpdatePullSecretRequest
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.PullSecretsApi(api_client)
    project_name = 'project_name_example' # str | Project name
    pullsecret_name = 'pullsecret_name_example' # str | PullSecret name
    v1_update_pull_secret_request = si_tests.clients.gcore.box_api.V1UpdatePullSecretRequest() # V1UpdatePullSecretRequest | PullSecret body

    try:
        # Update pull secret
        api_response = api_instance.v1_update_pull_secret(project_name, pullsecret_name, v1_update_pull_secret_request)
        print("The response of PullSecretsApi->v1_update_pull_secret:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling PullSecretsApi->v1_update_pull_secret: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 
 **pullsecret_name** | **str**| PullSecret name | 
 **v1_update_pull_secret_request** | [**V1UpdatePullSecretRequest**](V1UpdatePullSecretRequest.md)| PullSecret body | 

### Return type

[**V1PullSecretResponse**](V1PullSecretResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

