# si_tests.clients.gcore.box_api.DefaultQuotasApi

All URIs are relative to *http://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**v1_admin_create_default_quota**](DefaultQuotasApi.md#v1_admin_create_default_quota) | **POST** /v1/admin/default-quotas | Create default quota
[**v1_admin_default_delete_quota**](DefaultQuotasApi.md#v1_admin_default_delete_quota) | **DELETE** /v1/admin/default-quotas | Delete default quota
[**v1_admin_get_default_quota**](DefaultQuotasApi.md#v1_admin_get_default_quota) | **GET** /v1/admin/default-quotas | Get default quota
[**v1_admin_replace_quota**](DefaultQuotasApi.md#v1_admin_replace_quota) | **PUT** /v1/admin/default-quotas | Replace default quota


# **v1_admin_create_default_quota**
> ApiServicesDefaultquotasV1QuotaResponse v1_admin_create_default_quota(api_services_defaultquotas_v1_create_quota_request)

Create default quota

Creates a new resource default quota using the provided resource limits. That quota will be applied to all new projects created after this default quota.

Values must follow the Kubernetes quantity format.
See the documentation for details: https://kubernetes.io/docs/reference/kubernetes-api/common-definitions/quantity/

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.api_services_defaultquotas_v1_create_quota_request import ApiServicesDefaultquotasV1CreateQuotaRequest
from si_tests.clients.gcore.box_api.models.api_services_defaultquotas_v1_quota_response import ApiServicesDefaultquotasV1QuotaResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.DefaultQuotasApi(api_client)
    api_services_defaultquotas_v1_create_quota_request = si_tests.clients.gcore.box_api.ApiServicesDefaultquotasV1CreateQuotaRequest() # ApiServicesDefaultquotasV1CreateQuotaRequest | DefaultQuota

    try:
        # Create default quota
        api_response = api_instance.v1_admin_create_default_quota(api_services_defaultquotas_v1_create_quota_request)
        print("The response of DefaultQuotasApi->v1_admin_create_default_quota:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling DefaultQuotasApi->v1_admin_create_default_quota: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **api_services_defaultquotas_v1_create_quota_request** | [**ApiServicesDefaultquotasV1CreateQuotaRequest**](ApiServicesDefaultquotasV1CreateQuotaRequest.md)| DefaultQuota | 

### Return type

[**ApiServicesDefaultquotasV1QuotaResponse**](ApiServicesDefaultquotasV1QuotaResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**400** | Bad Request |  -  |
**409** | Conflict |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_admin_default_delete_quota**
> v1_admin_default_delete_quota()

Delete default quota

Deletes the default quota.

This operation cannot be undone. Make sure you have a backup if needed.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.DefaultQuotasApi(api_client)

    try:
        # Delete default quota
        api_instance.v1_admin_default_delete_quota()
    except Exception as e:
        print("Exception when calling DefaultQuotasApi->v1_admin_default_delete_quota: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |
**404** | Not Found |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_admin_get_default_quota**
> ApiServicesDefaultquotasV1QuotaResponse v1_admin_get_default_quota()

Get default quota

Retrieves the default quota information, including resource limits.

Values follow the Kubernetes quantity format.
See the documentation for details: https://kubernetes.io/docs/reference/kubernetes-api/common-definitions/quantity/


### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.api_services_defaultquotas_v1_quota_response import ApiServicesDefaultquotasV1QuotaResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.DefaultQuotasApi(api_client)

    try:
        # Get default quota
        api_response = api_instance.v1_admin_get_default_quota()
        print("The response of DefaultQuotasApi->v1_admin_get_default_quota:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling DefaultQuotasApi->v1_admin_get_default_quota: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**ApiServicesDefaultquotasV1QuotaResponse**](ApiServicesDefaultquotasV1QuotaResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_admin_replace_quota**
> ApiServicesDefaultquotasV1QuotaResponse v1_admin_replace_quota(v1_replace_quota_request)

Replace default quota

Replace the resource limits for default quotas.

Values must follow the Kubernetes quantity format.
See the documentation for details: https://kubernetes.io/docs/reference/kubernetes-api/common-definitions/quantity/

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.api_services_defaultquotas_v1_quota_response import ApiServicesDefaultquotasV1QuotaResponse
from si_tests.clients.gcore.box_api.models.v1_replace_quota_request import V1ReplaceQuotaRequest
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.DefaultQuotasApi(api_client)
    v1_replace_quota_request = si_tests.clients.gcore.box_api.V1ReplaceQuotaRequest() # V1ReplaceQuotaRequest | Quota

    try:
        # Replace default quota
        api_response = api_instance.v1_admin_replace_quota(v1_replace_quota_request)
        print("The response of DefaultQuotasApi->v1_admin_replace_quota:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling DefaultQuotasApi->v1_admin_replace_quota: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **v1_replace_quota_request** | [**V1ReplaceQuotaRequest**](V1ReplaceQuotaRequest.md)| Quota | 

### Return type

[**ApiServicesDefaultquotasV1QuotaResponse**](ApiServicesDefaultquotasV1QuotaResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**400** | Bad Request |  -  |
**404** | Not Found |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

