# si_tests.clients.gcore.box_api.AppsApi

All URIs are relative to *http://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**v1_delete_deployed_app**](AppsApi.md#v1_delete_deployed_app) | **DELETE** /v1/{project_name}/apps/deployments/{deploy_name} | Delete application deployment
[**v1_deploy_app**](AppsApi.md#v1_deploy_app) | **POST** /v1/{project_name}/apps/deployments | Create application deployment
[**v1_get_app_catalog**](AppsApi.md#v1_get_app_catalog) | **GET** /v1/apps/catalog/{app_name} | Get catalog application
[**v1_get_deployed_app**](AppsApi.md#v1_get_deployed_app) | **GET** /v1/{project_name}/apps/deployments/{deploy_name} | Get application deployment
[**v1_list_app_catalog**](AppsApi.md#v1_list_app_catalog) | **GET** /v1/apps/catalog | List catalog applications
[**v1_list_deployed_apps**](AppsApi.md#v1_list_deployed_apps) | **GET** /v1/{project_name}/apps/deployments | List application deployments
[**v1_update_deployed_app**](AppsApi.md#v1_update_deployed_app) | **PATCH** /v1/{project_name}/apps/deployments/{deploy_name} | Update application deployment


# **v1_delete_deployed_app**
> v1_delete_deployed_app(project_name, deploy_name)

Delete application deployment

This endpoint removes an application deployment and all its associated resources.

App deployments are user-created instances of application templates from the catalog.
Each app deployment consists of multiple inference deployments (e.g., one for the API
with the model itself and one for the UI that is configured to work with this API).

When you delete an application deployment:
- All components of the application are removed
- All underlying inference deployments are deleted
- All resources associated with the application are released
- The application is removed from all regions where it was deployed

Use this endpoint when you need to:
- Remove an application that is no longer needed
- Free up resources used by an application
- Clean up unused or obsolete application deployments

Warning: This operation cannot be undone. Make sure you no longer need the application
and its data before deleting it.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.AppsApi(api_client)
    project_name = 'project_name_example' # str | Project name
    deploy_name = 'deploy_name_example' # str | App Name

    try:
        # Delete application deployment
        api_instance.v1_delete_deployed_app(project_name, deploy_name)
    except Exception as e:
        print("Exception when calling AppsApi->v1_delete_deployed_app: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 
 **deploy_name** | **str**| App Name | 

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_deploy_app**
> SchemasAppDeployment v1_deploy_app(project_name, schemas_app_deployment_create_request, dry_run=dry_run)

Create application deployment

This endpoint creates a new application deployment from a template in the catalog.

App deployments are user-created instances of application templates from the catalog.
Each app deployment consists of multiple inference deployments (e.g., one for the API
with the model itself and one for the UI that is configured to work with this API).

When creating an application deployment, you can:
- Select which regions to deploy to
- Configure each component with appropriate resources (flavors)
- Set scaling parameters for each component
- Override default parameter values for components
- Choose which components to expose publicly

Use this endpoint when you need to:
- Deploy a new application from the catalog
- Create a customized instance of an application template

Note: This operation will create multiple inference deployments that are managed by
the application deployment. These inferences will be visible in the `/v1/{project_name}/inferences`
endpoints, but only in read-only mode and cannot be managed manually.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.schemas_app_deployment import SchemasAppDeployment
from si_tests.clients.gcore.box_api.models.schemas_app_deployment_create_request import SchemasAppDeploymentCreateRequest
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.AppsApi(api_client)
    project_name = 'project_name_example' # str | Project name
    schemas_app_deployment_create_request = si_tests.clients.gcore.box_api.SchemasAppDeploymentCreateRequest() # SchemasAppDeploymentCreateRequest | Application configuration
    dry_run = True # bool | Perform validation but do not apply any changes (optional)

    try:
        # Create application deployment
        api_response = api_instance.v1_deploy_app(project_name, schemas_app_deployment_create_request, dry_run=dry_run)
        print("The response of AppsApi->v1_deploy_app:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling AppsApi->v1_deploy_app: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 
 **schemas_app_deployment_create_request** | [**SchemasAppDeploymentCreateRequest**](SchemasAppDeploymentCreateRequest.md)| Application configuration | 
 **dry_run** | **bool**| Perform validation but do not apply any changes | [optional] 

### Return type

[**SchemasAppDeployment**](SchemasAppDeployment.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**201** | Created |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_get_app_catalog**
> SchemasApp v1_get_app_catalog(app_name)

Get catalog application

This endpoint retrieves detailed information about a specific application template from the catalog.

The apps catalog is a set of pre-defined applications consisting of multiple components
(e.g., an API with the model itself and a UI that is configured to work with this API).
Each application template includes metadata, component definitions, and configuration parameters.

Use this endpoint when you need to:
- View the details of a specific application template before deployment
- Understand the components and parameters available for configuration
- Access documentation and requirements for a particular application

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.schemas_app import SchemasApp
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.AppsApi(api_client)
    app_name = 'app_name_example' # str | App name

    try:
        # Get catalog application
        api_response = api_instance.v1_get_app_catalog(app_name)
        print("The response of AppsApi->v1_get_app_catalog:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling AppsApi->v1_get_app_catalog: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **app_name** | **str**| App name | 

### Return type

[**SchemasApp**](SchemasApp.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_get_deployed_app**
> SchemasAppDeployment v1_get_deployed_app(deploy_name, project_name)

Get application deployment

This endpoint retrieves detailed information about a specific deployed application.

App deployments are user-created instances of application templates from the catalog.
Each app deployment consists of multiple inference deployments (e.g., one for the API
with the model itself and one for the UI that is configured to work with this API).

The response includes:
- Configuration details for each component
- Status information across all regions
- Public endpoints for exposed components
- References to the underlying inference deployments

Use this endpoint when you need to:
- Check the detailed status of a specific application deployment
- View the configuration of an application's components
- Get access to the public endpoints of exposed components
- Find the names of the underlying inference deployments

Note: The inference deployments that are part of app deployments are also visible
in the /v1/{project_name}/inferences endpoints, but only in read-only mode.
They are managed by the parent application and cannot be managed manually.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.schemas_app_deployment import SchemasAppDeployment
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.AppsApi(api_client)
    deploy_name = 'deploy_name_example' # str | App Name
    project_name = 'project_name_example' # str | Project name

    try:
        # Get application deployment
        api_response = api_instance.v1_get_deployed_app(deploy_name, project_name)
        print("The response of AppsApi->v1_get_deployed_app:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling AppsApi->v1_get_deployed_app: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **deploy_name** | **str**| App Name | 
 **project_name** | **str**| Project name | 

### Return type

[**SchemasAppDeployment**](SchemasAppDeployment.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_list_app_catalog**
> SchemasAppListResponse v1_list_app_catalog()

List catalog applications

This endpoint retrieves a list of all available application templates in the catalog.

The apps catalog is a set of pre-defined applications consisting of multiple components
(e.g., an API with the model itself and a UI that is configured to work with this API).
Each application template in the catalog can be deployed to create a functioning application.

Use this endpoint when you need to:
- Browse available application templates
- Find applications that match your requirements
- Compare different application options before deployment

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.schemas_app_list_response import SchemasAppListResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.AppsApi(api_client)

    try:
        # List catalog applications
        api_response = api_instance.v1_list_app_catalog()
        print("The response of AppsApi->v1_list_app_catalog:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling AppsApi->v1_list_app_catalog: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**SchemasAppListResponse**](SchemasAppListResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_list_deployed_apps**
> SchemasAppDeploymentList v1_list_deployed_apps(project_name)

List application deployments

This endpoint retrieves a list of all deployed applications in the specified project.

App deployments are user-created instances of application templates from the catalog.
Each app deployment consists of multiple inference deployments (e.g., one for the API
with the model itself and one for the UI that is configured to work with this API).

Use this endpoint when you need to:
- View all deployed applications in a project
- Monitor the status of your application deployments
- Get an overview of deployed applications and their components

Note: The inference deployments that are part of app deployments are also visible
in the /v1/{project_name}/inferences endpoints, but only in read-only mode.
They are managed by the parent application and cannot be managed manually.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.schemas_app_deployment_list import SchemasAppDeploymentList
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.AppsApi(api_client)
    project_name = 'project_name_example' # str | Project name

    try:
        # List application deployments
        api_response = api_instance.v1_list_deployed_apps(project_name)
        print("The response of AppsApi->v1_list_deployed_apps:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling AppsApi->v1_list_deployed_apps: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 

### Return type

[**SchemasAppDeploymentList**](SchemasAppDeploymentList.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_update_deployed_app**
> SchemasAppDeployment v1_update_deployed_app(project_name, deploy_name, schemas_app_deployment_patch_request, dry_run=dry_run)

Update application deployment

This endpoint updates an existing application deployment's configuration.

App deployments are user-created instances of application templates from the catalog.
Each app deployment consists of multiple inference deployments (e.g., one for the API
with the model itself and one for the UI that is configured to work with this API).

When updating an application deployment, you can:
- Change which regions the application is deployed to
- Modify the configuration of individual components
- Update scaling parameters
- Change parameter overrides
- Enable or disable public exposure of components

Use this endpoint when you need to:
- Scale an application up or down
- Change the regions where an application is deployed
- Modify the configuration of an application's components
- Update parameter values for components

Note: This operation will update the underlying inference deployments that are managed by
the application deployment. These inferences are visible in the `/v1/{project_name}/inferences`
endpoints, but only in read-only mode and cannot be managed manually.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.schemas_app_deployment import SchemasAppDeployment
from si_tests.clients.gcore.box_api.models.schemas_app_deployment_patch_request import SchemasAppDeploymentPatchRequest
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.AppsApi(api_client)
    project_name = 'project_name_example' # str | Project name
    deploy_name = 'deploy_name_example' # str | App Name
    schemas_app_deployment_patch_request = si_tests.clients.gcore.box_api.SchemasAppDeploymentPatchRequest() # SchemasAppDeploymentPatchRequest | Application configuration
    dry_run = True # bool | Perform validation but do not apply any changes (optional)

    try:
        # Update application deployment
        api_response = api_instance.v1_update_deployed_app(project_name, deploy_name, schemas_app_deployment_patch_request, dry_run=dry_run)
        print("The response of AppsApi->v1_update_deployed_app:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling AppsApi->v1_update_deployed_app: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 
 **deploy_name** | **str**| App Name | 
 **schemas_app_deployment_patch_request** | [**SchemasAppDeploymentPatchRequest**](SchemasAppDeploymentPatchRequest.md)| Application configuration | 
 **dry_run** | **bool**| Perform validation but do not apply any changes | [optional] 

### Return type

[**SchemasAppDeployment**](SchemasAppDeployment.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

