# KSI Architecture Diagram

![diagram](https://www.plantuml.com/plantuml/png/bPDTZvGm58Rl-ojEvaelm0K_DCQOXHft29hPm2PxpPIJ0QUqs8-9nkn_jnG8ef7iNiBpdBSl7BZMfbB6TfmmBcqDcJ2e11geD6JmYm1K9nG6TZUjQUmH2Yi4AYXHNLg6kq6xsPC7Ge1C2OSUXGjbvu4TIf_Hu8_g90LaT_axxUyizoh50kLJ0psUcnHqSW24h17oClEN3wl1NNO7vojLktg-Hqu6WqmpHocDDghgDMBTITEWqatR3s9QEibrdWhJv3OhRTzBPR2-LVBIrgW6ZmubHgV0Koj5z5VrNNxuF26WadDaHYgWt6g3odSgelN0lLHdL2zeq_9w5Y7nwdsKFC9D9pVr3xkk5p-zNlpuUl4JwiLZFVUAR_Rm8GZyIj_3LGWLOzWR-2QFchYrGX1yXDoXA0I5torgeu6DOIJtD2r7p1HM1XTOPWkEGsY7ZuvpM5RzxCowvsllvU9DEL1Zp-NF3eNHG9mqk4KqkkiZP-eMjOtJBLp4cyDnierzzlRBU1L2DZsa-m36KSVeFsWzzleFLdw5T3__v7e-dVxVkg1Ufxq9WNAiXEs1VlcqtlNRXQNpNqgkKTIsuxy1)

``` plantuml
@startuml
cloud Openstack as OS {
  hexagon ITK8s {
    hexagon arc-runner-set as ARC {
      node KSI
    }
    hexagon k0rdent as K
  }

  node bootstrapseedmothership as BS
  
}

cloud CAPISupportedProvider as C{
  cloud Region1 {
    hexagon "KOF Region Collector Cluster" as R1
    hexagon "Worker/Child Cluster A" as W1A
    hexagon "Worker/Child Cluster B" as W1B
  }
  cloud Region2 {
    hexagon "KOF Region Collector Cluster" as R2
    hexagon "Worker/Child Cluster A" as W2A
    hexagon "Worker/Child Cluster B" as W2B
  }
}

KSI --> K : 1. requests cluster
K --> BS : 1. create cluster
KSI --> BS : 2. install mothership(kcm)
KSI --> BS : 3. install cluster deployments 
BS --> R1 : 3. create cluster
BS --> W1A : 3. create cluster
BS --> W1B : 3. create cluster
BS --> R2 : 3. create cluster
BS --> W2A : 3. create cluster
BS --> W2B : 3. create cluster
KSI --> BS : 4. Install KOF
BS ---> C : 4. Install KOF
KSI --> BS : 5. Install KSM BH Services
BS --> C : 5. Install KSM BH Servives
@enduml
```