import pytest

from si_tests import logger
from si_tests import settings
from qase.pytest import qase

LOG = logger.logger


@pytest.mark.usefixtures('log_step_time')
@pytest.mark.usefixtures('log_method_time')
@qase.title("Test Upgrade of KCM Management")
@qase.suite("Upgrade")
def test_upgrade(kcm_manager, kcm_bootstrap_manager, show_step):
    """Upgrade KCM management to target release

    Scenario:
        1. Create target release from KSI_UPGRADE_TARGET_RELEASE setting
        2. Patch management object with new release and verify upgrade started
        3. Wait for mgmt object readiness and check pods statuses
        4. Wait for expected pod checks to complete for target release
    """

    # Validate required settings
    assert settings.KSI_UPGRADE_TARGET_RELEASE, "KSI_UPGRADE_TARGET_RELEASE is required"

    show_step(1)
    LOG.info(f"Creating target release: {settings.KSI_UPGRADE_TARGET_RELEASE}")
    release = kcm_manager.create_release()

    show_step(2)
    LOG.info(f"Patching management object with release: {release.name}")
    kcm_manager.upgrade(release.name)

    # Wait for upgrade to start by checking that ready becomes false
    LOG.info("Waiting for upgrade to start (ready should become False)")
    kcm_bootstrap_manager.check.wait_for_mgmt_object_not_ready()

    show_step(3)
    # Wait for management object to become ready
    kcm_bootstrap_manager.check.wait_for_mgmt_object_readiness()
    kcm_bootstrap_manager.check.check_k8s_pods()

    show_step(4)
    # Refresh expected pods for the new release
    kcm_manager.refresh_expected_objects()
    # Check actual vs expected pods
    kcm_bootstrap_manager.check.check_actual_expected_pods()

    LOG.info(f"Upgrade to {release.name} (version {release.version}) completed successfully!")
