# Upgrade test module

## Overview

This directory contains tests related to upgrading k0rdent (KCM) management to target releases.

## Pre-requisites

- Working CNCF Kubernetes installation (KinD/k0s/Minikube/etc...)
- KUBECONFIG file
- KCM already installed
- Target release available in templates directory

## Test Suite

- [Upgrade KCM Management](#test_upgradepy)

## Existing tests and requirements

### test_upgrade.py

Upgrade KCM management cluster to a target release.

#### Scenario

1. Create target release from KSI_UPGRADE_TARGET_RELEASE setting
2. Patch management object with new release and verify upgrade started
3. Wait for expected pod checks to complete for target release

#### Variables that MUST be filled before run and have no default value

| ENV Variable                  | Type    | Description                                     | Example                  |
|-------------------------------|---------|-------------------------------------------------|--------------------------|
| `KUBECONFIG`                  | `<str>` | Path to KUBECONFIG file                         | `~/.kube/config`         |
| `KSI_UPGRADE_TARGET_RELEASE`  | `<str>` | Target release version to upgrade to            | `kcm-1-4-0`              |

#### Optional variables to customise the upgrade

| ENV Variable                  | Type    | Description                                     | Defaults                  |
|-------------------------------|---------|--------------------------------------------------|---------------------------|
| `KCM_NAMESPACE`               | `<str>` | Namespace where KCM is installed                 | `kcm-system`              |

#### Execution

First, install KCM using the bootstrap test:

```bash
# Set environment variables
export KUBECONFIG=~/.kube/config
export KCM_CHART_VERSION=1.2.0
export KCM_SOURCE=opensource

# Install KCM
pytest si_tests/tests/bootstrap/test_install_kcm.py
```

Then run the upgrade test:

```bash
# Set the target release version
export KSI_UPGRADE_TARGET_RELEASE=kcm-1-3-1

# Run upgrade test
pytest si_tests/tests/lcm/upgrade/test_upgrade.py
```

#### Example Environment File

Create a `.env` file with the following variables:

```bash
# Required: Path to kubeconfig
export KUBECONFIG=~/.kube/config

# Required for bootstrap: KCM chart version
export KCM_CHART_VERSION=1.2.0

# Optional: KCM source (opensource, enterprise, custom-enterprise)
export KCM_SOURCE=opensource

# Optional: KCM namespace
export KCM_NAMESPACE=kcm-system

# Required for upgrade: Target release version
export KSI_UPGRADE_TARGET_RELEASE=kcm-1-3-1
```

Then source the file before running tests:

```bash
source .env
pytest si_tests/tests/bootstrap/test_install_kcm.py
pytest si_tests/tests/lcm/upgrade/test_upgrade.py
```

## Complete Example Workflow

```bash
# 1. Create and configure environment file
cat > upgrade.env << 'EOF'
export KUBECONFIG=~/.kube/config
export KCM_CHART_VERSION=1.2.0
export KCM_SOURCE=opensource
export KCM_NAMESPACE=kcm-system
export KSI_UPGRADE_TARGET_RELEASE=kcm-1-3-1
EOF

# 2. Load environment variables
source upgrade.env

# 3. Install KCM (bootstrap)
pytest si_tests/tests/bootstrap/test_install_kcm.py

# 4. Run upgrade test
pytest si_tests/tests/lcm/upgrade/test_upgrade.py
```

## Upgrading to k0rdent Enterprise Releases

You can upgrade to k0rdent enterprise releases using the same upgrade test. Enterprise releases are available in the `si_tests/templates/releases` directory.

### Example: Upgrade to Enterprise Release

Set the target enterprise release and run the upgrade test:

```bash
export KSI_UPGRADE_TARGET_RELEASE=k0rdent-enterprise-1-1-0
pytest si_tests/tests/lcm/upgrade/test_upgrade.py
```

### Available Enterprise Releases

Currently available enterprise releases:
- `k0rdent-enterprise-1-0-0` - Enterprise 1.0.0
- `k0rdent-enterprise-1-1-0` - Enterprise 1.1.0

Note: Enterprise releases follow the pattern `k0rdent-enterprise-{major}-{minor}-{patch}` with hyphens instead of dots.

## Important Notes

- The upgrade test requires an existing KCM installation
- The upgrade process will update the management object to the new release version
