# Regional API test module

## Overview
This directory contains tests related to Regional API

## Test Suite

## Pre-requisites

- Working k0rdent kcm installation required to execute any of those tests
- Existing ClusterDeployment without region allocated to it

## Existing tests and requirements

### test_create_region.py
Create a Region object via Regional API and verify that the Region is created successfully. 
Additionally check the content of the cluster which became the regional (check the expected pods are running and ready).

#### Variables that MUST be filled before run and have no default value
| ENV Variable          | Type    | Description                   |
|-----------------------|---------|-------------------------------|
| `TARGET_CLD`          | `<str>` | Target clusterdeployment name |
| `KSI_KCM_REGION_NAME` | `<str>` | Name of the region to create  |

#### Optional variables with default values
| ENV Variable    | Type    | Default Value | Description                                                                                                                                               |
|-----------------|---------|---------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------|
| `KCM_NAMESPACE` | `<str>` | `kcm-system`  | Namespace where k0rdent kcm is installed and target clusterdeployment lives. Now it's limited to use only `KCM_NAMESPACE` for clusterdeployments with ksi |

### test_delete_region.py
Delete a Region object via Regional API and verify that the Region is deleted successfully.
Additionally check the content of the cluster which was the regional (check the regional pods cleared up)

#### Variables that MUST be filled before run and have no default value
| ENV Variable          | Type    | Description                  |
|-----------------------|---------|------------------------------|
| `KSI_KCM_REGION_NAME` | `<str>` | Name of the region to delete |

#### Optional variables with default values
| ENV Variable    | Type    | Default Value | Description                                                                                                                                               |
|-----------------|---------|---------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------|
| `KCM_NAMESPACE` | `<str>` | `kcm-system`  | Namespace where k0rdent kcm is installed and target clusterdeployment lives. Now it's limited to use only `KCM_NAMESPACE` for clusterdeployments with ksi |