import pytest

from si_tests import logger
from si_tests import settings

LOG = logger.logger


@pytest.mark.usefixtures('log_step_time')
@pytest.mark.usefixtures('log_method_time')
def test_create_ondemand_backup(kcm_manager, show_step):
    """Create an on-demand backup using ManagementBackup CRD

    Scenario:
        1. Create an on-demand backup with custom parameters
        2. Verify the backup resource was created successfully
        3. Wait for backup to complete successfully
    """

    show_step(1)
    backup = kcm_manager.create_backup_on_demand(backup_name=settings.KSI_BACKUP_NAME)

    show_step(2)
    assert backup is not None, "Failed to create backup resource"
    LOG.info(f"Created backup with name: {backup.name}")
    assert backup.storage_location == 'default', \
        f"Storage location mismatch. Expected: default, Got: {backup.storage_location}"

    # Verify backup exists in cluster (cluster-scoped resource)
    assert backup.exists(), f"Backup resource {backup.name} does not exist in cluster"

    show_step(3)
    # Wait for backup to complete successfully (will raise exception if failed)
    kcm_manager.wait_for_backup_completion(backup, timeout=1800)

    # Log final backup info
    LOG.info(f"Backup '{backup.name}' completed successfully and will be retained")
