# Backup and Restore test module

## Overview

This directory contains tests related to backup and restore operations for k0rdent (KCM) using Velero.

For more information about backup and restore configuration, see the [k0rdent documentation](https://docs.k0rdent.io/next/admin/backup/restore/).

## Pre-requisites

- Working CNCF Kubernetes installation (KinD/k0s/Minikube/etc...)
- KUBECONFIG file
- KCM Build uploaded to accessible registry
- AWS S3 bucket configured for Velero backup storage and accessible from the target cluster
- AWS credentials with appropriate permissions

## Test Suite

- [Create on-demand backup using ManagementBackup CRD](#test_ondemand_backuppy)
- [Restore KCM from Velero backup](#test_restorepy)

## Existing tests and requirements

### test_ondemand_backup.py

Create an on-demand backup using ManagementBackup CRD.

#### Scenario

1. Create an on-demand backup with custom parameters
2. Verify the backup resource was created successfully
3. Wait for backup to complete successfully

#### Variables that MUST be filled before run and have no default value

| ENV Variable                         | Type    | Description                                      | Example                  |
|--------------------------------------|---------|--------------------------------------------------|--------------------------|
| `KUBECONFIG`                         | `<str>` | Path to KUBECONFIG file                          | `./kubeconfig`           |
| `AWS_ACCESS_KEY_ID`                  | `<str>` | AWS access key for Velero storage                | `AKIAIOSFODNN7EXAMPLE`   |
| `AWS_SECRET_ACCESS_KEY`              | `<str>` | AWS secret key for Velero storage                | `wJalrXUtnFEMI...`       |
| `KSI_VELERO_BACKUP_STORAGE_BUCKET`   | `<str>` | S3 bucket name where backups are stored          | `my-velero-backups`      |

#### Optional variables to customise the backup

| ENV Variable                          | Type    | Description                                      | Defaults                  |
|---------------------------------------|---------|--------------------------------------------------|---------------------------|
| `KCM_NAMESPACE`                       | `<str>` | Namespace where KCM is installed                 | `kcm-system`              |
| `KSI_BACKUP_NAME`                     | `<str>` | Name for the on-demand backup                    | Auto-generated if not set |
| `KSI_VELERO_BACKUP_STORAGE_REGION`    | `<str>` | AWS region for backup storage                    | `us-east-1`               |
| `KSI_VELERO_PLUGIN_PROVIDER_NAME`     | `<str>` | Velero plugin provider                           | `aws`                     |
| `KSI_VELERO_PLUGIN_PROVIDER_TAG`      | `<str>` | Version tag for the Velero plugin                | `v1.13.0`                 |

#### Execution

```bash
py.test $(KSI_HOME)/si_tests/tests/lcm/backup-restore/test_ondemand_backup.py
```

### test_restore.py

Restore KCM from Velero backup to a new cluster.

#### Scenario

1. Install k0rdent with restore configuration
2. Create Velero AWS credentials secret
3. Create backup storage location
4. Wait for backup storage location to be ready
5. Wait for Velero to reconcile existing backups
6. Apply restore from specified backup
7. Wait for restore completion
8. Verify management objects are restored

#### Variables that MUST be filled before run and have no default value

| ENV Variable                         | Type    | Description                                      | Example                  |
|--------------------------------------|---------|--------------------------------------------------|--------------------------|
| `KUBECONFIG`                         | `<str>` | Path to KUBECONFIG file                          | `./kubeconfig`           |
| `AWS_ACCESS_KEY_ID`                  | `<str>` | AWS access key for Velero storage                | `AKIAIOSFODNN7EXAMPLE`   |
| `AWS_SECRET_ACCESS_KEY`              | `<str>` | AWS secret key for Velero storage                | `wJalrXUtnFEMI...`       |
| `KSI_VELERO_BACKUP_NAME`             | `<str>` | Name of the Velero backup to restore from        | `kcm-backup-001`         |
| `KSI_VELERO_BACKUP_STORAGE_BUCKET`   | `<str>` | S3 bucket name where backups are stored          | `my-velero-backups`      |
| `KCM_CHART_VERSION`                  | `<str>` | Version of KCM chart to install                  | `0.2.0` or `0.2.0-rc1`   |

#### Optional variables to customise the restore

| ENV Variable                          | Type    | Description                                      | Defaults                  |
|---------------------------------------|---------|--------------------------------------------------|---------------------------|
| `KCM_NAMESPACE`                       | `<str>` | Namespace to install kcm                         | `kcm-system`              |
| `KSI_VELERO_RESTORE_NAME`             | `<str>` | Name for the restore resource                    | `ksi-restore-{timestamp}` |
| `KCM_SOURCE`                          | `<str>` | KCM source of chart                              | `enterprise`              |
| `KSI_VELERO_BACKUP_STORAGE_REGION`    | `<str>` | AWS region for backup storage                    | `us-east-1`               |
| `KSI_VELERO_PLUGIN_PROVIDER_NAME`     | `<str>` | Velero plugin provider                           | `aws`                     |
| `KSI_VELERO_PLUGIN_PROVIDER_TAG`      | `<str>` | Version tag for the Velero plugin                | `v1.13.0`                 |

#### Execution

```bash
py.test $(KSI_HOME)/si_tests/tests/lcm/backup-restore/test_restore.py
```

## Important Notes

- The restore test requires a fresh Kubernetes cluster without existing KCM installation
- Backup and restore operations use Velero under the hood
- AWS S3 is currently the supported backup storage backend
- The restore process will recreate management objects from the backup