import pytest

from si_tests import logger
from si_tests import settings

LOG = logger.logger


@pytest.mark.usefixtures('log_step_time')
@pytest.mark.usefixtures('log_method_time')
def test_cleanup_kof_mothership(kcm_bootstrap_manager, show_step):
    """Install and configure kof into k0rdent management cluster

    Scenario:
        1. Get kof namespace and check that kof present
        2. Remove grafana dashboards and datasources
        3. Remove kof-istio chart and wait
        4. Remove kof-child chart and wait
        5. Remove kof-regional chart and wait
        6. Remove kof-collectors chart and wait
        7. Remove kof-mothership chart and wait
        8. Remove kof-operators chart and wait
        9. Remove kof namespace
    """
    show_step(1)
    kcm_manager = kcm_bootstrap_manager.check.kcm_mgr
    kof_ns = None
    namespaces = kcm_manager.get_namespaces()
    if settings.KSI_KOF_NAMESPACE not in [ns.name for ns in namespaces]:
        pytest.skip(f"{settings.KSI_KOF_NAMESPACE} not present. Nothing to cleanup")
    else:
        kof_ns = kcm_manager.get_namespace(settings.KSI_KOF_NAMESPACE)

    show_step(2)
    if kcm_manager.kof.is_kof_mothership_present():
        kcm_bootstrap_manager.check.cleanup_grafana_entities()

    show_step(3)
    if kcm_manager.kof.is_kof_istio_present():
        kcm_bootstrap_manager.check.uninstall_kof_istio_and_wait()
        kcm_manager.refresh_expected_objects()
        kcm_bootstrap_manager.check.check_k8s_pods()
        kcm_bootstrap_manager.check.check_actual_expected_pods()

    show_step(4)
    if kcm_manager.kof.is_kof_child_present():
        kcm_bootstrap_manager.check.uninstall_kof_child_and_wait()
        kcm_manager.refresh_expected_objects()
        kcm_bootstrap_manager.check.check_k8s_pods()
        kcm_bootstrap_manager.check.check_actual_expected_pods()

    show_step(5)
    if kcm_manager.kof.is_kof_regional_present():
        kcm_bootstrap_manager.check.uninstall_kof_regional_and_wait()
        kcm_manager.refresh_expected_objects()
        kcm_bootstrap_manager.check.check_k8s_pods()
        kcm_bootstrap_manager.check.check_actual_expected_pods()

    show_step(6)
    if kcm_manager.kof.is_kof_collectors_present():
        kcm_bootstrap_manager.check.uninstall_kof_collectors_and_wait()
        kcm_manager.refresh_expected_objects()
        kcm_bootstrap_manager.check.check_k8s_pods()
        kcm_bootstrap_manager.check.check_actual_expected_pods()

    show_step(7)
    if kcm_manager.kof.is_kof_mothership_present():
        kcm_bootstrap_manager.check.uninstall_kof_mothership_and_wait()
        kcm_manager.refresh_expected_objects()
        kcm_bootstrap_manager.check.check_k8s_pods()
        kcm_bootstrap_manager.check.check_actual_expected_pods()

    show_step(8)
    if kcm_manager.kof.is_kof_operators_present():
        kcm_bootstrap_manager.check.uninstall_kof_op_and_wait()
        kcm_manager.refresh_expected_objects()
        kcm_bootstrap_manager.check.check_k8s_pods()
        kcm_bootstrap_manager.check.check_actual_expected_pods()

    show_step(9)
    kof_ns.delete(a_sync=False)
    if settings.KSI_KOF_ISTIO_NAMESPACE in [ns.name for ns in namespaces]:
        kof_istio_ns = kcm_manager.get_namespace(settings.KSI_KOF_ISTIO_NAMESPACE)
        kof_istio_ns.delete(a_sync=False)
