import pytest

from si_tests import settings
from si_tests import logger

LOG = logger.logger


# Global variables to store test resources for dependency chain
test_resources = {
    'box_cluster_name': settings.KSI_INFERENCE_BOX_CLUSTER_NAME,
    'project_name': settings.KSI_INFERENCE_TEST_PROJECT_NAME,
    'nodegroup_name': settings.KSI_INFERENCE_TEST_NODEGROUP_NAME,
    'usergroup_name': settings.KSI_INFERENCE_TEST_USERGROUP_NAME,
    'user_name': settings.KSI_INFERENCE_TEST_USER_NAME,
    'apikey_name': settings.KSI_INFERENCE_TEST_APIKEY_NAME,
    'app_model_flavor_name': settings.KSI_INFERENCE_TEST_FLAVOR_NAME,
    'app_ui_flavor_name': 'test-flavor-1vcpu-2gib',

    'mlapp_name': settings.KSI_INFERENCE_TEST_MLAPP_NAME,
    'mlapptemplate_name': settings.KSI_INFERENCE_TEST_MLAPPTEMPLATE_NAME,

    # Resources that get created during test execution
    'box_api_client': None,
    'inference_manager': None,

}


@pytest.fixture(scope='session')
def setup_test_resources(box_api_client, inference_manager):
    """Setup basic test resources - step 1"""
    # Store the clients for reuse
    test_resources['box_api_client'] = box_api_client
    test_resources['inference_manager'] = inference_manager


cleanup_resources_params = [
    ('application',
     lambda: test_resources['inference_manager'].is_mlapp_exists(
         test_resources['project_name'], test_resources['mlapp_name']),
     lambda: test_resources['inference_manager'].delete_mlapp(
         test_resources['project_name'], test_resources['mlapp_name']),
     ),
    ('apikey',
     lambda: test_resources['inference_manager'].is_apikey_exists(
         test_resources['apikey_name'], test_resources['project_name']),
     lambda: test_resources['inference_manager'].delete_apikey(
         test_resources['apikey_name'], test_resources['project_name']),
     ),
    ('user',
     lambda: test_resources['inference_manager'].is_user_exists(
         test_resources['user_name']),
     lambda: test_resources['inference_manager'].delete_user(
         test_resources['user_name']),
     ),
    ('usergroup',
     lambda: test_resources['inference_manager'].is_usergroup_exists(
         test_resources['usergroup_name']),
     lambda: test_resources['inference_manager'].delete_usergroup(
         test_resources['usergroup_name']),
     ),
    ('nodegroup',
     lambda: test_resources['inference_manager'].is_nodegroup_exists(
         test_resources['nodegroup_name']),
     lambda: test_resources['inference_manager'].delete_nodegroup(
         test_resources['nodegroup_name']),
     ),
    ('ui-flavor',
     lambda: test_resources['inference_manager'].is_flavor_exists(
         test_resources['app_ui_flavor_name']),
     lambda: test_resources['inference_manager'].delete_flavor(
         test_resources['app_ui_flavor_name']),
     ),
    ('model-flavor',
     lambda: test_resources['inference_manager'].is_flavor_exists(
         test_resources['app_model_flavor_name']),
     lambda: test_resources['inference_manager'].delete_flavor(
         test_resources['app_model_flavor_name']),
     ),
    ('project',
     lambda: test_resources['inference_manager'].is_project_exists(
         test_resources['project_name']),
     lambda: test_resources['inference_manager'].delete_project(
         test_resources['project_name']),
     ),
]


@pytest.mark.usefixtures('setup_test_resources')
@pytest.mark.parametrize(
    ("resource_key", "is_resource_exists", "delete_func"),
    cleanup_resources_params,
    ids=[k for k, _, _ in cleanup_resources_params],
)
def test_delete_mlapp_resources(resource_key, is_resource_exists, delete_func):
    """Delete all the resources created by this test"""
    if is_resource_exists():
        delete_func()
    else:
        LOG.error(f"*** SKIP: Resource '{resource_key}' not found to delete")
        pytest.skip(f"Resource '{resource_key}' not found to delete")
