import pytest

from si_tests import settings
from si_tests import logger

LOG = logger.logger


# Global variables to store test resources for dependency chain
test_resources = {
    'box_cluster_name': settings.KSI_INFERENCE_BOX_CLUSTER_NAME,
    'project_name': settings.KSI_INFERENCE_TEST_PROJECT_NAME,
    'nodegroup_name': settings.KSI_INFERENCE_TEST_NODEGROUP_NAME,
    'usergroup_name': settings.KSI_INFERENCE_TEST_USERGROUP_NAME,
    'user_name': settings.KSI_INFERENCE_TEST_USER_NAME,
    'registry_name': settings.KSI_INFERENCE_TEST_REGISTRY_NAME,
    'registry_user_name': settings.KSI_INFERENCE_TEST_REGISTRY_USER_NAME,
    'registry_storage_limit': settings.KSI_INFERENCE_TEST_REGISTRY_STORAGE_LIMIT,
    'pod_image_src_registry_url': settings.KSI_INFERENCE_TEST_POD_IMAGE_SRC_REGISTRY_URL,
    'pod_image_src_registry_user': settings.KSI_INFERENCE_TEST_POD_IMAGE_SRC_REGISTRY_USER or None,
    'pod_image_src_registry_password': settings.KSI_INFERENCE_TEST_POD_IMAGE_SRC_REGISTRY_PASSWORD or None,
    'pod_image_name': settings.KSI_INFERENCE_TEST_POD_IMAGE_NAME,
    'pod_image_tag': settings.KSI_INFERENCE_TEST_POD_IMAGE_TAG,
    'pod_image_replication_adapter_type': settings.KSI_INFERENCE_TEST_POD_IMAGE_REPLICATION_ADAPTER_TYPE,
    'volume_image_src_registry_url': settings.KSI_INFERENCE_TEST_VOLUME_IMAGE_SRC_REGISTRY_URL,
    'volume_image_src_registry_user': settings.KSI_INFERENCE_TEST_VOLUME_IMAGE_SRC_REGISTRY_USER or None,
    'volume_image_src_registry_password': settings.KSI_INFERENCE_TEST_VOLUME_IMAGE_SRC_REGISTRY_PASSWORD or None,
    'volume_image_name': settings.KSI_INFERENCE_TEST_VOLUME_IMAGE_NAME,
    'volume_image_tag': settings.KSI_INFERENCE_TEST_VOLUME_IMAGE_TAG,
    'volume_image_replication_adapter_type': settings.KSI_INFERENCE_TEST_VOLUME_IMAGE_REPLICATION_ADAPTER_TYPE,
    'volume_image_mount_path': settings.KSI_INFERENCE_TEST_VOLUME_IMAGE_MOUNT_PATH,
    'volume_name': settings.KSI_INFERENCE_TEST_VOLUME_NAME,
    'apikey_name': settings.KSI_INFERENCE_TEST_APIKEY_NAME,
    'inference_flavor_name': settings.KSI_INFERENCE_TEST_FLAVOR_NAME,
    'inference_flavor_cpu': settings.KSI_INFERENCE_TEST_FLAVOR_CPU,
    'inference_flavor_memory': settings.KSI_INFERENCE_TEST_FLAVOR_MEMORY,
    'inference_flavor_gpu': settings.KSI_INFERENCE_TEST_FLAVOR_GPU or None,
    'inference_flavor_gpu_model': settings.KSI_INFERENCE_TEST_FLAVOR_GPU_MODEL or None,
    'inference_flavor_is_gpu_shared': settings.KSI_INFERENCE_TEST_FLAVOR_IS_GPU_SHARED,
    'inference_port': settings.KSI_INFERENCE_TEST_INFERENCE_PORT,
    'inference_name': settings.KSI_INFERENCE_TEST_INFERENCE_NAME,

    # Resources that get created during test execution
    'box_api_client': None,
    'inference_manager': None,
    'inference_user_manager': None,
    'usergroup': None,
    'user': None,
    'user_password': None,
    'apikey': None,
    'project': None,
    'pod_image_replicated': False,
    'volume_image_replicated': False,
    'nodegroup': None,
    'registry': None,
    'registry_user': None,
    'volume': None,
    'flavor': None,
    'inference': None,
    'inference_disabled': False,
    'addresses': None
}


@pytest.fixture(scope='session')
def setup_test_resources(box_api_client, inference_manager):
    """Setup basic test resources - step 1"""
    # Store the clients for reuse
    test_resources['box_api_client'] = box_api_client
    test_resources['inference_manager'] = inference_manager


cleanup_resources_params = [
    ('inference',
     lambda: test_resources['inference_manager'].is_inference_exists(
         test_resources['project_name'], test_resources['inference_name']),
     lambda: test_resources['inference_manager'].delete_inference(
         test_resources['project_name'], test_resources['inference_name']),
     ),
    ('volume',
     lambda: test_resources['inference_manager'].is_volume_exists(
         test_resources['volume_name'], test_resources['project_name']),
     lambda: test_resources['inference_manager'].delete_volume(
         test_resources['volume_name'], test_resources['project_name']),
     ),
    ('registry_user',
     lambda: test_resources['inference_manager'].is_registry_user_exists(
         test_resources['registry_user_name'], test_resources['registry_name'], test_resources['project_name']),
     lambda: test_resources['inference_manager'].delete_registry_user(
         test_resources['registry_user_name'], test_resources['registry_name'], test_resources['project_name']),
     ),
    ('registry',
     lambda: test_resources['inference_manager'].is_registry_exists(
         test_resources['registry_name'], test_resources['project_name']),
     lambda: test_resources['inference_manager'].delete_registry(
         test_resources['registry_name'], test_resources['project_name']),
     ),
    ('apikey',
     lambda: test_resources['inference_manager'].is_apikey_exists(
         test_resources['apikey_name'], test_resources['project_name']),
     lambda: test_resources['inference_manager'].delete_apikey(
         test_resources['apikey_name'], test_resources['project_name']),
     ),
    ('user',
     lambda: test_resources['inference_manager'].is_user_exists(
         test_resources['user_name']),
     lambda: test_resources['inference_manager'].delete_user(
         test_resources['user_name']),
     ),
    ('usergroup',
     lambda: test_resources['inference_manager'].is_usergroup_exists(
         test_resources['usergroup_name']),
     lambda: test_resources['inference_manager'].delete_usergroup(
         test_resources['usergroup_name']),
     ),
    ('nodegroup',
     lambda: test_resources['inference_manager'].is_nodegroup_exists(
         test_resources['nodegroup_name']),
     lambda: test_resources['inference_manager'].delete_nodegroup(
         test_resources['nodegroup_name']),
     ),
    ('flavor',
     lambda: test_resources['inference_manager'].is_flavor_exists(
         test_resources['inference_flavor_name']),
     lambda: test_resources['inference_manager'].delete_flavor(
         test_resources['inference_flavor_name']),
     ),
    ('project',
     lambda: test_resources['inference_manager'].is_project_exists(
         test_resources['project_name']),
     lambda: test_resources['inference_manager'].delete_project(
         test_resources['project_name']),
     ),
]


@pytest.mark.usefixtures('setup_test_resources')
@pytest.mark.parametrize(
    ("resource_key", "is_resource_exists", "delete_func"),
    cleanup_resources_params,
    ids=[k for k, _, _ in cleanup_resources_params],
)
def test_step_18_delete_resource(resource_key, is_resource_exists, delete_func):
    """Step 18: Delete all the resources created by this test"""
    if resource_key not in test_resources:
        raise Exception(f"Resource key '{resource_key}' not found in the dict 'test_resources'")

    if is_resource_exists():
        delete_func()
    else:
        LOG.error(f"*** SKIP: Resource '{resource_key}' not found to delete")
        pytest.skip(f"Resource '{resource_key}' not found to delete")
