from si_tests import settings
from si_tests import logger

LOG = logger.logger


def test_openwebui_sanity_response(inference_manager, show_step):
    """Simple test to ensure that a model behind OpenWebUI is working

    Scenario:
        1. Get an OpenWebUI token from existing user, or create an admin account
        2. Find an Inference model that has 'root' mount path
        3. Make a request to this model
        4. Check that the request was interpreted correctly
    """

    project_name = settings.KSI_INFERENCE_TEST_PROJECT_NAME
    mlapp_name = settings.KSI_INFERENCE_TEST_MLAPP_NAME
    email = settings.KSI_INFERENCE_TEST_MLAPP_UI_LOGIN
    password = settings.KSI_INFERENCE_TEST_MLAPP_UI_PASSWORD
    assert password, "Environment variable KSI_INFERENCE_TEST_MLAPP_UI_PASSWORD is not set"

    show_step(1)
    openwebui_manager = inference_manager.get_openwebui_manager(project_name, mlapp_name, email, password)

    show_step(2)
    model = openwebui_manager.get_model()

    show_step(3)
    request_content = ("Show me only a string with sequence of the digits "
                       "from 0 to 9 without any separators between them")
    LOG.info(f"Request:\n\n{request_content}\n")
    response_content = openwebui_manager.get_model_response(model, request_content)

    show_step(4)
    assert response_content
    LOG.info(f"Response:\n\n{response_content}\n")
    assert '0123456789' in response_content, (
        "Expected string in the response: '0123456789', but got: '{response_content}'")
