def test_check_mcs_mgmt_readiness(kcm_manager):
    """Check the child cluster readiness"""
    mgmt_cluster_name = "mgmt"
    mgmt_cluster_namespace = "mgmt"

    mcss = kcm_manager.api.k0rdent_multi_cluster_services.list_all()
    for mcs in mcss:
        mgmt_cluster_conditions = mcs.get_cluster_conditions(
            cluster_name=mgmt_cluster_name, cluster_namespace=mgmt_cluster_namespace)
        if not mgmt_cluster_conditions:
            continue

        mcs.wait_for_services_readiness(
            cluster_name=mgmt_cluster_name, cluster_namespace=mgmt_cluster_namespace)

    kcm_manager.api.pods.check_k8s_pods()
    kcm_manager.api.nodes.check_k8s_nodes()
