from si_tests import settings


def test_check_mcs_child_readiness(kcm_manager):
    """Check the child cluster readiness"""
    ns = kcm_manager.get_namespace(settings.TARGET_NAMESPACE)
    cld = ns.get_cluster_deployment(settings.TARGET_CLD)

    mcss = kcm_manager.api.k0rdent_multi_cluster_services.list_all()
    for mcs in mcss:
        cluster_conditions = mcs.get_cluster_conditions(
            cluster_name=cld.name, cluster_namespace=cld.namespace)
        if not cluster_conditions:
            continue

        mcs.wait_for_services_readiness(
            cluster_name=cld.name, cluster_namespace=cld.namespace)

    cld.check.check_cluster_readiness(timeout=600)
    cld.check.check_k8s_pods()
    cld.check.check_k8s_nodes()
