#!/bin/bash

# Download all KCM release.yaml files

releases=(
  "v1.4.0:kcm-1-4-0"
  "v1.3.1:kcm-1-3-1"
  "v1.3.0:kcm-1-3-0"
  "v1.2.0:kcm-1-2-0"
  "v1.1.1:kcm-1-1-1"
  "v1.1.0:kcm-1-1-0"
  "v1.0.0:kcm-1-0-0"
  "v0.3.0:kcm-0-3-0"
)

base_url="https://github.com/k0rdent/kcm/releases/download"

for release in "${releases[@]}"; do
  version="${release%%:*}"
  filename="${release##*:}"

  echo "Downloading ${version}..."
  curl -L -o "${filename}.yaml" "${base_url}/${version}/release.yaml"

  if [ $? -eq 0 ]; then
    echo "✓ Successfully downloaded ${filename}.yaml"
  else
    echo "✗ Failed to download ${version}"
  fi
done

echo "Done!"
