#!/bin/bash

# Download all k0rdent-enterprise release.yaml files

releases=(
  "1.2.0-alpha1:k0rdent-enterprise-1-2-0-alpha1"
  "1.2.0:k0rdent-enterprise-1-2-0"
  "1.1.0:k0rdent-enterprise-1-1-0"
  "1.0.0:k0rdent-enterprise-1-0-0"
)

base_url="https://get.mirantis.com/k0rdent-enterprise"

failed_releases=()

for release in "${releases[@]}"; do
  version="${release%%:*}"
  filename="${release##*:}"

  echo "Downloading ${version}..."
  http_code=$(curl -L -w "%{http_code}" -o "${filename}.yaml" "${base_url}/${version}/release.yaml" 2>/dev/null)
  curl_exit=$?

  if [ "$http_code" = "404" ]; then
    echo "✗ Failed to download ${version}: 404 Not Found"
    rm -f "${filename}.yaml"
    failed_releases+=("${version} (404)")
  elif [ $curl_exit -eq 0 ] && [ "$http_code" = "200" ]; then
    echo "✓ Successfully downloaded ${filename}.yaml"
  else
    echo "✗ Failed to download ${version} (HTTP ${http_code})"
    rm -f "${filename}.yaml"
    failed_releases+=("${version} (HTTP ${http_code})")
  fi
done

if [ ${#failed_releases[@]} -gt 0 ]; then
  echo ""
  echo "Failed to download ${#failed_releases[@]} release(s):"
  for failed in "${failed_releases[@]}"; do
    echo "  - ${failed}"
  done
fi

echo "Done!"
