import pytest

from si_tests.clients.gcore.box_api_client import BoxApiClient
from si_tests.managers.inference_manager import InferenceManager
from si_tests import settings


@pytest.fixture(scope='session')
def box_api_client():
    keycloak_url = settings.KSI_INFERENCE_BOX_KEYCLOAK_URL
    box_api_url = settings.KSI_INFERENCE_BOX_API_URL
    username = settings.KSI_INFERENCE_BOX_API_USERNAME
    password = settings.KSI_INFERENCE_BOX_API_PASSWORD
    client_id = settings.KSI_INFERENCE_BOX_KEYCLOAK_CLIENT_ID
    realm_name = settings.KSI_INFERENCE_BOX_KEYCLOAK_REALM_NAME
    box_client = BoxApiClient(keycloak_url, box_api_url, username, password, client_id, realm_name)
    return box_client


@pytest.fixture(scope='session')
def inference_manager(box_api_client):
    return InferenceManager(box_api_client=box_api_client)
