#    Copyright 2025 Mirantis, Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations

from si_tests.clients.k8s import base


class V1K0rdentProviderInterface(base.BaseModel):
    pass


class V1K0rdentProviderInterfaceList(base.BaseModelList):
    pass


class K0rdentProviderInterface(base.K8sClusterScopedResource):
    resource_type = 'providerinterface'
    model = V1K0rdentProviderInterface


class K0rdentProviderInterfaceManager(base.K8sBaseManager):
    model = V1K0rdentProviderInterfaceList
    resource_class = K0rdentProviderInterface
    resource_group = 'k0rdent.mirantis.com'
    resource_version = 'v1beta1'
    resource_plural = 'providerinterfaces'
