#    Copyright 2025 Mirantis, Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations

from si_tests.clients.k8s import base


class V1Machine(base.BaseModel):
    pass


class V1MachineList(base.BaseModelList):
    pass


class Machine(base.K8sNamespacedResource):
    resource_type = 'machine'
    model = V1Machine

    @property
    def cluster_name(self):
        cluster_name = self.read().spec['clusterName']
        return cluster_name

    @property
    def phase(self):
        status = self.read().status
        phase = None
        if status:
            phase = status.get('phase', None)
        return phase

    @property
    def node_name(self):
        name = None
        status = self.read().status
        if status and status.get('nodeRef', {}):
            name = status.get('nodeRef', {}).get('name')
        return name

    @property
    def spec(self):
        return self.read().spec


class MachineManager(base.K8sBaseManager):
    model = V1MachineList
    resource_class = Machine
    resource_group = 'cluster.x-k8s.io'
    resource_version = 'v1beta1'
    resource_plural = 'machines'
