# coding: utf-8

"""
    Inference Box API

    ## Welcome to Inference Box API  A comprehensive REST API for managing cloud infrastructure resources including ML inference deployments, Kubernetes resources, and application lifecycle management.  ## Overview  Inference Box API is a cloud-native REST API service that provides unified access to manage:  - **ML Inference Deployments**: Create, manage, and scale machine learning inference services - **Slurm Clusters**: Deploy, configure, and manage HPC Slurm clusters for batch workloads - **Kubernetes Resources**: Manage namespaces (projects), pods, secrets, volumes, and other K8s resources - **Application Lifecycle**: Deploy and manage applications from catalog templates - **Resource Management**: Handle flavors, capacities, quotas, and node groups - **User & Access Control**: Manage users, groups, and API keys with RBAC integration - **Monitoring & Metrics**: Query metrics and monitor resource usage via Victoria Metrics  The service is built with Go and integrates with Kubernetes, HashiCorp Vault, and Victoria Metrics to provide a complete cloud infrastructure management solution.  ## Key API Endpoints  - **Inference**: `/v1/{project_name}/inferences` - ML inference deployment management - **Inference (Admin)**: `/v1/admin/{project_name}/inferences` - ML inference deployment management (admin only) - **Slurm Clusters**: `/v1/{project_name}/slurm/clusters` - Slurm cluster deployment and management - **Flavors**: `/v1/flavors` - Compute resource flavor definitions - **Flavors Management**: `/v1/admin/flavors` - Compute resource flavor definitions management - **Users**: `/v1/admin/users` - User management (admin only) - **Projects**: `/v1/{project_name}` - Project-scoped resource operations - **Metrics**: `/v1/{project_name}/metrics` - Resource usage metrics  ## Getting Started  ### Authentication  All API requests require authentication using the `X-API-Key` header. Most operations are scoped to specific projects/namespaces.  ### API Organization  The API is organized into logical groups: - **Public endpoints**: `/v1/*` - General access endpoints - **Project-scoped**: `/v1/{project_name}/*` - Project-specific resources - **Admin endpoints**: `/v1/admin/*` - Administrative operations  ### Documentation  Interactive documentation is available at `/docs` when the service is running. 

    The version of the OpenAPI document: 2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import unittest

from si_tests.clients.gcore.box_api.models.v1_list_slurm_clusters_response import V1ListSlurmClustersResponse

class TestV1ListSlurmClustersResponse(unittest.TestCase):
    """V1ListSlurmClustersResponse unit test stubs"""

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def make_instance(self, include_optional) -> V1ListSlurmClustersResponse:
        """Test V1ListSlurmClustersResponse
            include_optional is a boolean, when False only required
            params are included, when True both required and
            optional params are included """
        # uncomment below to create an instance of `V1ListSlurmClustersResponse`
        """
        model = V1ListSlurmClustersResponse()
        if include_optional:
            return V1ListSlurmClustersResponse(
                count = 1,
                results = [
                    si_tests.clients.gcore.box_api.models.v1/slurm_cluster_response.v1.SlurmClusterResponse(
                        created_at = '2025-07-01T12:00:00Z', 
                        login = si_tests.clients.gcore.box_api.models.v1/slurm_cluster_login_config.v1.SlurmClusterLoginConfig(
                            address = '', 
                            ssh_keys = [ssh-ed25519 AAAAC3NzaC1l...], ), 
                        region_name = 'luxembourg', 
                        status = 'Ready', 
                        worker = si_tests.clients.gcore.box_api.models.v1/slurm_cluster_worker_config.v1.SlurmClusterWorkerConfig(
                            flavor_name = 'inference-16vcpu-232gib-1xh100-48gb', 
                            size = 2, 
                            volume_name = 'my-cluster-spool', ), )
                    ]
            )
        else:
            return V1ListSlurmClustersResponse(
        )
        """

    def testV1ListSlurmClustersResponse(self):
        """Test V1ListSlurmClustersResponse"""
        # inst_req_only = self.make_instance(include_optional=False)
        # inst_req_and_optional = self.make_instance(include_optional=True)

if __name__ == '__main__':
    unittest.main()
