# coding: utf-8

"""
    Inference Box API

    ## Welcome to Inference Box API  A comprehensive REST API for managing cloud infrastructure resources including ML inference deployments, Kubernetes resources, and application lifecycle management.  ## Overview  Inference Box API is a cloud-native REST API service that provides unified access to manage:  - **ML Inference Deployments**: Create, manage, and scale machine learning inference services - **Slurm Clusters**: Deploy, configure, and manage HPC Slurm clusters for batch workloads - **Kubernetes Resources**: Manage namespaces (projects), pods, secrets, volumes, and other K8s resources - **Application Lifecycle**: Deploy and manage applications from catalog templates - **Resource Management**: Handle flavors, capacities, quotas, and node groups - **User & Access Control**: Manage users, groups, and API keys with RBAC integration - **Monitoring & Metrics**: Query metrics and monitor resource usage via Victoria Metrics  The service is built with Go and integrates with Kubernetes, HashiCorp Vault, and Victoria Metrics to provide a complete cloud infrastructure management solution.  ## Key API Endpoints  - **Inference**: `/v1/{project_name}/inferences` - ML inference deployment management - **Inference (Admin)**: `/v1/admin/{project_name}/inferences` - ML inference deployment management (admin only) - **Slurm Clusters**: `/v1/{project_name}/slurm/clusters` - Slurm cluster deployment and management - **Flavors**: `/v1/flavors` - Compute resource flavor definitions - **Flavors Management**: `/v1/admin/flavors` - Compute resource flavor definitions management - **Users**: `/v1/admin/users` - User management (admin only) - **Projects**: `/v1/{project_name}` - Project-scoped resource operations - **Metrics**: `/v1/{project_name}/metrics` - Resource usage metrics  ## Getting Started  ### Authentication  All API requests require authentication using the `X-API-Key` header. Most operations are scoped to specific projects/namespaces.  ### API Organization  The API is organized into logical groups: - **Public endpoints**: `/v1/*` - General access endpoints - **Project-scoped**: `/v1/{project_name}/*` - Project-specific resources - **Admin endpoints**: `/v1/admin/*` - Administrative operations  ### Documentation  Interactive documentation is available at `/docs` when the service is running. 

    The version of the OpenAPI document: 2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import unittest

from si_tests.clients.gcore.box_api.models.v1_create_inference_request import V1CreateInferenceRequest

class TestV1CreateInferenceRequest(unittest.TestCase):
    """V1CreateInferenceRequest unit test stubs"""

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def make_instance(self, include_optional) -> V1CreateInferenceRequest:
        """Test V1CreateInferenceRequest
            include_optional is a boolean, when False only required
            params are included, when True both required and
            optional params are included """
        # uncomment below to create an instance of `V1CreateInferenceRequest`
        """
        model = V1CreateInferenceRequest()
        if include_optional:
            return V1CreateInferenceRequest(
                api_keys = [
                    ''
                    ],
                command = [python, main.py, --port, 8080],
                deployment_strategy = si_tests.clients.gcore.box_api.models.v1/deployment_strategy_spec.v1.DeploymentStrategySpec(
                    type = 'RollingUpdate', ),
                description = '',
                enable_pod_distribution = True,
                envs = {
                    'key' : ''
                    },
                envs_per_region = {
                    'key' : {
                        'key' : ''
                        }
                    },
                expose = 'gcore-geodns',
                flavor = si_tests.clients.gcore.box_api.models.v1/flavor_ref.v1.FlavorRef(
                    name = '', ),
                host_header = '',
                image = 'gcr.io/my-project/my-inference:latest',
                ingress_opts = si_tests.clients.gcore.box_api.models.v1/ingress_opts.v1.IngressOpts(
                    disable_response_buffering = True, 
                    read_timeout = 0, ),
                is_disabled = True,
                is_ingress_disabled = True,
                listening_port = 1,
                logging = si_tests.clients.gcore.box_api.models.v1/logging.v1.Logging(
                    destination_region_id = 1, 
                    enabled = True, 
                    kafka_endpoints = [laas-in.lux.cloud.example.com:443], 
                    kafka_password = 'pass', 
                    kafka_topics = [some-namespace.some-topic], 
                    kafka_username = 'user', ),
                metadata = {
                    'key' : ''
                    },
                metrics_port = 1,
                name = 'inference-1',
                probes = si_tests.clients.gcore.box_api.models.v1/probes.v1.Probes(
                    liveness_probe = si_tests.clients.gcore.box_api.models.v1/probe_configuration.v1.ProbeConfiguration(
                        enabled = True, 
                        probe = si_tests.clients.gcore.box_api.models.v1/container_probe.v1.ContainerProbe(
                            exec = si_tests.clients.gcore.box_api.models.v1/exec_probe.v1.ExecProbe(
                                command = [
                                    ''
                                    ], ), 
                            failure_threshold = 3, 
                            http_get = si_tests.clients.gcore.box_api.models.v1/http_get_probe.v1.HttpGetProbe(
                                headers = {
                                    'key' : ''
                                    }, 
                                host = '', 
                                path = '', 
                                port = 56, 
                                schema = '', ), 
                            initial_delay_seconds = 5, 
                            period_seconds = 5, 
                            success_threshold = 1, 
                            tcp_socket = si_tests.clients.gcore.box_api.models.v1/tcp_socket_probe.v1.TcpSocketProbe(
                                port = 56, ), 
                            timeout_seconds = 5, ), ), 
                    readiness_probe = si_tests.clients.gcore.box_api.models.v1/probe_configuration.v1.ProbeConfiguration(
                        enabled = True, ), 
                    startup_probe = , ),
                pull_secret = '',
                regions = [
                    ''
                    ],
                registry = si_tests.clients.gcore.box_api.models.v1/registry_ref.v1.RegistryRef(
                    name = '', ),
                registry_image = si_tests.clients.gcore.box_api.models.v1/registry_image_ref.v1.RegistryImageRef(
                    name = 'nginx', 
                    tag = 'latest', ),
                registry_user = si_tests.clients.gcore.box_api.models.v1/registry_user_ref.v1.RegistryUserRef(
                    name = 'registry-user', ),
                scale_per_region = {
                    'key' : si_tests.clients.gcore.box_api.models.v1/create_scale_request.v1.CreateScaleRequest(
                        cooldown_period = 60, 
                        max = 1, 
                        min = 0, 
                        polling_interval = 10, 
                        triggers = si_tests.clients.gcore.box_api.models.v1/create_scale_triggers.v1.CreateScaleTriggers(
                            cpu = si_tests.clients.gcore.box_api.models.v1/cpu_trigger.v1.CpuTrigger(
                                threshold = 80, ), 
                            gpu_memory = si_tests.clients.gcore.box_api.models.v1/gpu_memory_trigger.v1.GpuMemoryTrigger(
                                threshold = 80, ), 
                            gpu_utilization = si_tests.clients.gcore.box_api.models.v1/gpu_utilization_trigger.v1.GpuUtilizationTrigger(
                                threshold = 80, ), 
                            http = si_tests.clients.gcore.box_api.models.v1/http_trigger.v1.HttpTrigger(
                                rate = 10, 
                                window = 60, ), 
                            memory = si_tests.clients.gcore.box_api.models.v1/memory_trigger.v1.MemoryTrigger(
                                threshold = 80, ), 
                            sqs = si_tests.clients.gcore.box_api.models.v1/sqs_trigger.v1.SqsTrigger(
                                activation_queue_length = 56, 
                                aws_endpoint = '', 
                                aws_region = '', 
                                queue_length = 56, 
                                queue_url = '', 
                                scale_on_delayed = True, 
                                scale_on_flight = True, 
                                secret_name = '', ), ), )
                    },
                timeout = 56,
                tls_secret = '',
                volumes = [
                    si_tests.clients.gcore.box_api.models.api_services_inference_v1/volume.api_services_inference_v1.Volume(
                        claim_name = 'my-claim', 
                        empty_dir_size_limit = '1Gi', 
                        image_reference = 'nginx:latest', 
                        mount_path = '/var/www/html', 
                        name = 'my-volume', 
                        sub_path = '/subpath', )
                    ]
            )
        else:
            return V1CreateInferenceRequest(
                flavor = si_tests.clients.gcore.box_api.models.v1/flavor_ref.v1.FlavorRef(
                    name = '', ),
                listening_port = 1,
                name = 'inference-1',
                regions = [
                    ''
                    ],
                scale_per_region = {
                    'key' : si_tests.clients.gcore.box_api.models.v1/create_scale_request.v1.CreateScaleRequest(
                        cooldown_period = 60, 
                        max = 1, 
                        min = 0, 
                        polling_interval = 10, 
                        triggers = si_tests.clients.gcore.box_api.models.v1/create_scale_triggers.v1.CreateScaleTriggers(
                            cpu = si_tests.clients.gcore.box_api.models.v1/cpu_trigger.v1.CpuTrigger(
                                threshold = 80, ), 
                            gpu_memory = si_tests.clients.gcore.box_api.models.v1/gpu_memory_trigger.v1.GpuMemoryTrigger(
                                threshold = 80, ), 
                            gpu_utilization = si_tests.clients.gcore.box_api.models.v1/gpu_utilization_trigger.v1.GpuUtilizationTrigger(
                                threshold = 80, ), 
                            http = si_tests.clients.gcore.box_api.models.v1/http_trigger.v1.HttpTrigger(
                                rate = 10, 
                                window = 60, ), 
                            memory = si_tests.clients.gcore.box_api.models.v1/memory_trigger.v1.MemoryTrigger(
                                threshold = 80, ), 
                            sqs = si_tests.clients.gcore.box_api.models.v1/sqs_trigger.v1.SqsTrigger(
                                activation_queue_length = 56, 
                                aws_endpoint = '', 
                                aws_region = '', 
                                queue_length = 56, 
                                queue_url = '', 
                                scale_on_delayed = True, 
                                scale_on_flight = True, 
                                secret_name = '', ), ), )
                    },
        )
        """

    def testV1CreateInferenceRequest(self):
        """Test V1CreateInferenceRequest"""
        # inst_req_only = self.make_instance(include_optional=False)
        # inst_req_and_optional = self.make_instance(include_optional=True)

if __name__ == '__main__':
    unittest.main()
