# coding: utf-8

"""
    Inference Box API

    ## Welcome to Inference Box API  A comprehensive REST API for managing cloud infrastructure resources including ML inference deployments, Kubernetes resources, and application lifecycle management.  ## Overview  Inference Box API is a cloud-native REST API service that provides unified access to manage:  - **ML Inference Deployments**: Create, manage, and scale machine learning inference services - **Slurm Clusters**: Deploy, configure, and manage HPC Slurm clusters for batch workloads - **Kubernetes Resources**: Manage namespaces (projects), pods, secrets, volumes, and other K8s resources - **Application Lifecycle**: Deploy and manage applications from catalog templates - **Resource Management**: Handle flavors, capacities, quotas, and node groups - **User & Access Control**: Manage users, groups, and API keys with RBAC integration - **Monitoring & Metrics**: Query metrics and monitor resource usage via Victoria Metrics  The service is built with Go and integrates with Kubernetes, HashiCorp Vault, and Victoria Metrics to provide a complete cloud infrastructure management solution.  ## Key API Endpoints  - **Inference**: `/v1/{project_name}/inferences` - ML inference deployment management - **Inference (Admin)**: `/v1/admin/{project_name}/inferences` - ML inference deployment management (admin only) - **Slurm Clusters**: `/v1/{project_name}/slurm/clusters` - Slurm cluster deployment and management - **Flavors**: `/v1/flavors` - Compute resource flavor definitions - **Flavors Management**: `/v1/admin/flavors` - Compute resource flavor definitions management - **Users**: `/v1/admin/users` - User management (admin only) - **Projects**: `/v1/{project_name}` - Project-scoped resource operations - **Metrics**: `/v1/{project_name}/metrics` - Resource usage metrics  ## Getting Started  ### Authentication  All API requests require authentication using the `X-API-Key` header. Most operations are scoped to specific projects/namespaces.  ### API Organization  The API is organized into logical groups: - **Public endpoints**: `/v1/*` - General access endpoints - **Project-scoped**: `/v1/{project_name}/*` - Project-specific resources - **Admin endpoints**: `/v1/admin/*` - Administrative operations  ### Documentation  Interactive documentation is available at `/docs` when the service is running. 

    The version of the OpenAPI document: 2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import unittest

from si_tests.clients.gcore.box_api.api.user_groups_api import UserGroupsApi


class TestUserGroupsApi(unittest.TestCase):
    """UserGroupsApi unit test stubs"""

    def setUp(self) -> None:
        self.api = UserGroupsApi()

    def tearDown(self) -> None:
        pass

    def test_v1_create_group(self) -> None:
        """Test case for v1_create_group

        Create user group
        """
        pass

    def test_v1_delete_group(self) -> None:
        """Test case for v1_delete_group

        Delete user group
        """
        pass

    def test_v1_get_group(self) -> None:
        """Test case for v1_get_group

        Get user group
        """
        pass

    def test_v1_groups_list(self) -> None:
        """Test case for v1_groups_list

        Get current user's groups
        """
        pass

    def test_v1_list_groups(self) -> None:
        """Test case for v1_list_groups

        List user groups
        """
        pass

    def test_v1_replace_group(self) -> None:
        """Test case for v1_replace_group

        Replace user group
        """
        pass


if __name__ == '__main__':
    unittest.main()
