# coding: utf-8

"""
    Inference Box API

    ## Welcome to Inference Box API  A comprehensive REST API for managing cloud infrastructure resources including ML inference deployments, Kubernetes resources, and application lifecycle management.  ## Overview  Inference Box API is a cloud-native REST API service that provides unified access to manage:  - **ML Inference Deployments**: Create, manage, and scale machine learning inference services - **Slurm Clusters**: Deploy, configure, and manage HPC Slurm clusters for batch workloads - **Kubernetes Resources**: Manage namespaces (projects), pods, secrets, volumes, and other K8s resources - **Application Lifecycle**: Deploy and manage applications from catalog templates - **Resource Management**: Handle flavors, capacities, quotas, and node groups - **User & Access Control**: Manage users, groups, and API keys with RBAC integration - **Monitoring & Metrics**: Query metrics and monitor resource usage via Victoria Metrics  The service is built with Go and integrates with Kubernetes, HashiCorp Vault, and Victoria Metrics to provide a complete cloud infrastructure management solution.  ## Key API Endpoints  - **Inference**: `/v1/{project_name}/inferences` - ML inference deployment management - **Inference (Admin)**: `/v1/admin/{project_name}/inferences` - ML inference deployment management (admin only) - **Slurm Clusters**: `/v1/{project_name}/slurm/clusters` - Slurm cluster deployment and management - **Flavors**: `/v1/flavors` - Compute resource flavor definitions - **Flavors Management**: `/v1/admin/flavors` - Compute resource flavor definitions management - **Users**: `/v1/admin/users` - User management (admin only) - **Projects**: `/v1/{project_name}` - Project-scoped resource operations - **Metrics**: `/v1/{project_name}/metrics` - Resource usage metrics  ## Getting Started  ### Authentication  All API requests require authentication using the `X-API-Key` header. Most operations are scoped to specific projects/namespaces.  ### API Organization  The API is organized into logical groups: - **Public endpoints**: `/v1/*` - General access endpoints - **Project-scoped**: `/v1/{project_name}/*` - Project-specific resources - **Admin endpoints**: `/v1/admin/*` - Administrative operations  ### Documentation  Interactive documentation is available at `/docs` when the service is running. 

    The version of the OpenAPI document: 2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import unittest

from si_tests.clients.gcore.box_api.api.quotas_api import QuotasApi


class TestQuotasApi(unittest.TestCase):
    """QuotasApi unit test stubs"""

    def setUp(self) -> None:
        self.api = QuotasApi()

    def tearDown(self) -> None:
        pass

    def test_v1_admin_create_quota(self) -> None:
        """Test case for v1_admin_create_quota

        Create quota
        """
        pass

    def test_v1_admin_delete_quota(self) -> None:
        """Test case for v1_admin_delete_quota

        Delete quota
        """
        pass

    def test_v1_admin_list_quota_resource_types(self) -> None:
        """Test case for v1_admin_list_quota_resource_types

        List available resource types
        """
        pass

    def test_v1_admin_list_quotas(self) -> None:
        """Test case for v1_admin_list_quotas

        List all quotas
        """
        pass

    def test_v1_admin_update_quota(self) -> None:
        """Test case for v1_admin_update_quota

        Update quota
        """
        pass

    def test_v1_get_admin_quota(self) -> None:
        """Test case for v1_get_admin_quota

        Get quotas per project
        """
        pass

    def test_v1_get_quota(self) -> None:
        """Test case for v1_get_quota

        Get quota
        """
        pass

    def test_v1_request_quota(self) -> None:
        """Test case for v1_request_quota

        Request quota
        """
        pass


if __name__ == '__main__':
    unittest.main()
