# coding: utf-8

"""
    Inference Box API

    ## Welcome to Inference Box API  A comprehensive REST API for managing cloud infrastructure resources including ML inference deployments, Kubernetes resources, and application lifecycle management.  ## Overview  Inference Box API is a cloud-native REST API service that provides unified access to manage:  - **ML Inference Deployments**: Create, manage, and scale machine learning inference services - **Slurm Clusters**: Deploy, configure, and manage HPC Slurm clusters for batch workloads - **Kubernetes Resources**: Manage namespaces (projects), pods, secrets, volumes, and other K8s resources - **Application Lifecycle**: Deploy and manage applications from catalog templates - **Resource Management**: Handle flavors, capacities, quotas, and node groups - **User & Access Control**: Manage users, groups, and API keys with RBAC integration - **Monitoring & Metrics**: Query metrics and monitor resource usage via Victoria Metrics  The service is built with Go and integrates with Kubernetes, HashiCorp Vault, and Victoria Metrics to provide a complete cloud infrastructure management solution.  ## Key API Endpoints  - **Inference**: `/v1/{project_name}/inferences` - ML inference deployment management - **Inference (Admin)**: `/v1/admin/{project_name}/inferences` - ML inference deployment management (admin only) - **Slurm Clusters**: `/v1/{project_name}/slurm/clusters` - Slurm cluster deployment and management - **Flavors**: `/v1/flavors` - Compute resource flavor definitions - **Flavors Management**: `/v1/admin/flavors` - Compute resource flavor definitions management - **Users**: `/v1/admin/users` - User management (admin only) - **Projects**: `/v1/{project_name}` - Project-scoped resource operations - **Metrics**: `/v1/{project_name}/metrics` - Resource usage metrics  ## Getting Started  ### Authentication  All API requests require authentication using the `X-API-Key` header. Most operations are scoped to specific projects/namespaces.  ### API Organization  The API is organized into logical groups: - **Public endpoints**: `/v1/*` - General access endpoints - **Project-scoped**: `/v1/{project_name}/*` - Project-specific resources - **Admin endpoints**: `/v1/admin/*` - Administrative operations  ### Documentation  Interactive documentation is available at `/docs` when the service is running. 

    The version of the OpenAPI document: 2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from si_tests.clients.gcore.box_api.models.schemas_app_inference import SchemasAppInference
from si_tests.clients.gcore.box_api.models.schemas_expose_address import SchemasExposeAddress
from si_tests.clients.gcore.box_api.models.schemas_region_status import SchemasRegionStatus
from typing import Optional, Set
from typing_extensions import Self

class SchemasStatus(BaseModel):
    """
    Status represents the current state of the deployment across regions.
    """ # noqa: E501
    component_inferences: Optional[Dict[str, SchemasAppInference]] = Field(default=None, description="ComponentInferences contains a map of a component and its inference")
    consolidated_status: Optional[StrictStr] = Field(default=None, description="ConsolidatedStatus provides a high-level summary of the deployment status across all regions.")
    expose_addresses: Optional[Dict[str, SchemasExposeAddress]] = Field(default=None, description="ExposeAddresses contains a map of a component key to")
    regions: Optional[Dict[str, SchemasRegionStatus]] = Field(default=None, description="Regions contain status details for each region where the application is deployed.")
    __properties: ClassVar[List[str]] = ["component_inferences", "consolidated_status", "expose_addresses", "regions"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SchemasStatus from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in component_inferences (dict)
        _field_dict = {}
        if self.component_inferences:
            for _key_component_inferences in self.component_inferences:
                if self.component_inferences[_key_component_inferences]:
                    _field_dict[_key_component_inferences] = self.component_inferences[_key_component_inferences].to_dict()
            _dict['component_inferences'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in expose_addresses (dict)
        _field_dict = {}
        if self.expose_addresses:
            for _key_expose_addresses in self.expose_addresses:
                if self.expose_addresses[_key_expose_addresses]:
                    _field_dict[_key_expose_addresses] = self.expose_addresses[_key_expose_addresses].to_dict()
            _dict['expose_addresses'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in regions (dict)
        _field_dict = {}
        if self.regions:
            for _key_regions in self.regions:
                if self.regions[_key_regions]:
                    _field_dict[_key_regions] = self.regions[_key_regions].to_dict()
            _dict['regions'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SchemasStatus from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "component_inferences": dict(
                (_k, SchemasAppInference.from_dict(_v))
                for _k, _v in obj["component_inferences"].items()
            )
            if obj.get("component_inferences") is not None
            else None,
            "consolidated_status": obj.get("consolidated_status"),
            "expose_addresses": dict(
                (_k, SchemasExposeAddress.from_dict(_v))
                for _k, _v in obj["expose_addresses"].items()
            )
            if obj.get("expose_addresses") is not None
            else None,
            "regions": dict(
                (_k, SchemasRegionStatus.from_dict(_v))
                for _k, _v in obj["regions"].items()
            )
            if obj.get("regions") is not None
            else None
        })
        return _obj


