# V1Logging

Logging configures Fluent Bit log forwarding.

## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**destination_region_id** | **int** | DestinationRegionID stores the destination region to which the logs are forwarded. | [optional] 
**enabled** | **bool** | Enabled indicates if log forwarding should be enabled or not. | [optional] 
**kafka_endpoints** | **List[str]** | KafkaEndpoints are Kafka broker URLs to forward the logs to. | [optional] 
**kafka_password** | **str** | KafkaPassword is the Kafka rdkafka.sasl.password to use for authorization. | [optional] 
**kafka_topics** | **List[str]** | KafkaTopics are Kafka output topics to forward the logs to. | [optional] 
**kafka_username** | **str** | KafkaUsername is the Kafka rdkafka.sasl.username to use for authorization. | [optional] 

## Example

```python
from si_tests.clients.gcore.box_api.models.v1_logging import V1Logging

# TODO update the JSON string below
json = "{}"
# create an instance of V1Logging from a JSON string
v1_logging_instance = V1Logging.from_json(json)
# print the JSON string representation of the object
print(V1Logging.to_json())

# convert the object into a dict
v1_logging_dict = v1_logging_instance.to_dict()
# create an instance of V1Logging from a dict
v1_logging_from_dict = V1Logging.from_dict(v1_logging_dict)
```
[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)


