# V1InferenceResponse


## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**api_keys** | **List[str]** | API keys assigned to the inference deployment | [optional] 
**command** | **List[str]** | Command of the inference | [optional] 
**created_at** | **str** | CreatedAt is the time when the inference was created | [optional] 
**deployment_strategy** | [**V1DeploymentStrategySpec**](V1DeploymentStrategySpec.md) |  | [optional] 
**description** | **str** | Description of the inference | [optional] 
**enable_pod_distribution** | **bool** | EnablePodDistribution indicates if inference pods are equally distributed across nodes | [optional] 
**envs** | **Dict[str, str]** | Envs of the inference, global, will be overwritten by envs_per_region | [optional] 
**envs_per_region** | **Dict[str, Dict[str, str]]** | EnvsPerRegion of the inference, will be merged with envs | [optional] 
**expose** | **str** | Expose type of the inference | [optional] 
**flavor** | [**ApiServicesInferenceV1Flavor**](ApiServicesInferenceV1Flavor.md) |  | [optional] 
**host_header** | **str** | HostHeader of the inference | [optional] 
**id** | **str** | ID of the inference | [optional] 
**image** | **str** | Image of the inference | [optional] 
**ingress_opts** | [**V1IngressOpts**](V1IngressOpts.md) |  | [optional] 
**is_api_key_enabled** | **bool** | IsApiKeysEnabled indicates if API keys are enabled for the inference Deprecated: will be removed in the near future | [optional] 
**is_disabled** | **bool** | IsDisabled of the inference | [optional] 
**is_ingress_disabled** | **bool** | IsIngressDisabled of the inference | [optional] 
**is_paused** | **bool** | IsPaused indicates if inference is paused (no scaling, no updates) | [optional] 
**listening_port** | **int** | ListeningPort of the inference | [optional] 
**logging** | [**V1Logging**](V1Logging.md) |  | [optional] 
**metadata** | **Dict[str, str]** | Metadata is the metadata of the inference | [optional] 
**metrics_port** | **int** | MetricsPort of the inference | [optional] 
**name** | **str** | Name of the inference | [optional] 
**namespace** | **str** | Namespace of the inference | [optional] 
**object_references** | [**List[ApiUtilReferencesObjectReference]**](ApiUtilReferencesObjectReference.md) | ObjectReferences indicates parent resources for inference | [optional] 
**probes** | [**V1Probes**](V1Probes.md) |  | [optional] 
**pull_secret** | **str** | PullSecret of the inference | [optional] 
**read_only** | **bool** | ReadOnly indicates if inference not manageable | [optional] 
**regions** | **List[str]** | Regions of the inference | [optional] 
**registry** | [**V1RegistryRef**](V1RegistryRef.md) |  | [optional] 
**registry_image** | [**V1RegistryImageRef**](V1RegistryImageRef.md) |  | [optional] 
**registry_user** | [**V1RegistryUserRef**](V1RegistryUserRef.md) |  | [optional] 
**scale_per_region** | [**Dict[str, V1Scale]**](V1Scale.md) | ScalePerRegion scale configuration per region | [optional] 
**status** | **str** | InferenceStatus of the inference | [optional] 
**statuses** | [**Dict[str, V1Status]**](V1Status.md) | Statuses of the inference by region | [optional] 
**timeout** | **int** | Timeout of the inference | [optional] 
**tls_secret** | **str** | TlsSecret of inference | [optional] 
**volumes** | [**List[ApiServicesInferenceV1Volume]**](ApiServicesInferenceV1Volume.md) | Volumes of the inference | [optional] 

## Example

```python
from si_tests.clients.gcore.box_api.models.v1_inference_response import V1InferenceResponse

# TODO update the JSON string below
json = "{}"
# create an instance of V1InferenceResponse from a JSON string
v1_inference_response_instance = V1InferenceResponse.from_json(json)
# print the JSON string representation of the object
print(V1InferenceResponse.to_json())

# convert the object into a dict
v1_inference_response_dict = v1_inference_response_instance.to_dict()
# create an instance of V1InferenceResponse from a dict
v1_inference_response_from_dict = V1InferenceResponse.from_dict(v1_inference_response_dict)
```
[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)


