# V1DeploymentStrategySpec

DeploymentStrategy defines the deployment strategy to use for container deployment.  One of:   - Recreate:       Terminates all existing Pods before creating new ones,       ensuring a full restart of the workload.   - RollingUpdate (default):       Gradually replaces Pods with new ones to maintain availability,       but is incompatible with distributed inference workloads that require       all replicas to start simultaneously.

## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**type** | **str** | Type of deployment strategy. If not specified, defaults to RollingUpdate. | [optional] 

## Example

```python
from si_tests.clients.gcore.box_api.models.v1_deployment_strategy_spec import V1DeploymentStrategySpec

# TODO update the JSON string below
json = "{}"
# create an instance of V1DeploymentStrategySpec from a JSON string
v1_deployment_strategy_spec_instance = V1DeploymentStrategySpec.from_json(json)
# print the JSON string representation of the object
print(V1DeploymentStrategySpec.to_json())

# convert the object into a dict
v1_deployment_strategy_spec_dict = v1_deployment_strategy_spec_instance.to_dict()
# create an instance of V1DeploymentStrategySpec from a dict
v1_deployment_strategy_spec_from_dict = V1DeploymentStrategySpec.from_dict(v1_deployment_strategy_spec_dict)
```
[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)


