# V1CreateInferenceRequest


## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**api_keys** | **List[str]** | API keys assigned to the inference deployment | [optional] 
**command** | **List[str]** | Command of the inference | [optional] 
**deployment_strategy** | [**V1DeploymentStrategySpec**](V1DeploymentStrategySpec.md) |  | [optional] 
**description** | **str** | Description of the inference | [optional] 
**enable_pod_distribution** | **bool** | EnablePodDistribution enables distributing inference pods across nodes, so that no two pods are deployed on the same node. | [optional] 
**envs** | **Dict[str, str]** | Envs of the inference, global, will be overwritten if envs_per_region provided | [optional] 
**envs_per_region** | **Dict[str, Dict[str, str]]** | EnvsPerRegion env variables per region, will be merged with global envs | [optional] 
**expose** | **str** | Expose of the inference | [optional] 
**flavor** | [**V1FlavorRef**](V1FlavorRef.md) |  | 
**host_header** | **str** | HostHeader of the inference | [optional] 
**image** | **str** | Image of the inference | [optional] 
**ingress_opts** | [**V1IngressOpts**](V1IngressOpts.md) |  | [optional] 
**is_disabled** | **bool** | IsDisabled of the inference | [optional] 
**is_ingress_disabled** | **bool** | IsIngressDisabled of the inference | [optional] 
**listening_port** | **int** | ListeningPort of the inference | 
**logging** | [**V1Logging**](V1Logging.md) |  | [optional] 
**metadata** | **Dict[str, str]** | Metadata of the inference | [optional] 
**metrics_port** | **int** | MetricsPort of the inference. Defaults to listening_port if not set. | [optional] 
**name** | **str** | Name of the inference | 
**probes** | [**V1Probes**](V1Probes.md) |  | [optional] 
**pull_secret** | **str** | PullSecret of the inference | [optional] 
**regions** | **List[str]** | Regions of the inference | 
**registry** | [**V1RegistryRef**](V1RegistryRef.md) |  | [optional] 
**registry_image** | [**V1RegistryImageRef**](V1RegistryImageRef.md) |  | [optional] 
**registry_user** | [**V1RegistryUserRef**](V1RegistryUserRef.md) |  | [optional] 
**scale_per_region** | [**Dict[str, V1CreateScaleRequest]**](V1CreateScaleRequest.md) | ScalePerRegion if set scale will be ignored and scale per region will be used | 
**timeout** | **int** | Timeout of the inference | [optional] 
**tls_secret** | **str** | Tls certificate name | [optional] 
**volumes** | [**List[ApiServicesInferenceV1Volume]**](ApiServicesInferenceV1Volume.md) | Volumes of the inference | [optional] 

## Example

```python
from si_tests.clients.gcore.box_api.models.v1_create_inference_request import V1CreateInferenceRequest

# TODO update the JSON string below
json = "{}"
# create an instance of V1CreateInferenceRequest from a JSON string
v1_create_inference_request_instance = V1CreateInferenceRequest.from_json(json)
# print the JSON string representation of the object
print(V1CreateInferenceRequest.to_json())

# convert the object into a dict
v1_create_inference_request_dict = v1_create_inference_request_instance.to_dict()
# create an instance of V1CreateInferenceRequest from a dict
v1_create_inference_request_from_dict = V1CreateInferenceRequest.from_dict(v1_create_inference_request_dict)
```
[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)


