# si_tests.clients.gcore.box_api.RegistriesApi

All URIs are relative to *http://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**v1_create_registry**](RegistriesApi.md#v1_create_registry) | **POST** /v1/{project_name}/registries | Create container registry
[**v1_delete_registry**](RegistriesApi.md#v1_delete_registry) | **DELETE** /v1/{project_name}/registries/{registry_name} | Delete container registry
[**v1_delete_registry_image**](RegistriesApi.md#v1_delete_registry_image) | **DELETE** /v1/{project_name}/registries/{registry_name}/images/{image_name} | Delete registry image
[**v1_get_registry**](RegistriesApi.md#v1_get_registry) | **GET** /v1/{project_name}/registries/{registry_name} | Get container registry
[**v1_list_registries**](RegistriesApi.md#v1_list_registries) | **GET** /v1/{project_name}/registries | List container registries
[**v1_list_registry_images**](RegistriesApi.md#v1_list_registry_images) | **GET** /v1/{project_name}/registries/{registry_name}/images | List registry images
[**v1_update_registry**](RegistriesApi.md#v1_update_registry) | **PUT** /v1/{project_name}/registries/{registry_name} | Update container registry


# **v1_create_registry**
> ApiServicesRegistriesV1RegistryResponse v1_create_registry(project_name, v1_create_registry_request)

Create container registry

Creates a new container registry in the specified project.

This endpoint allows you to create a private or public container registry with a specified
storage limit and optional preheat policies. The registry can be used to store and distribute
container images within your project. Once created, you can push and pull images to and from
the registry using standard container tools like Docker or Podman.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.api_services_registries_v1_registry_response import ApiServicesRegistriesV1RegistryResponse
from si_tests.clients.gcore.box_api.models.v1_create_registry_request import V1CreateRegistryRequest
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.RegistriesApi(api_client)
    project_name = 'project_name_example' # str | Project name
    v1_create_registry_request = si_tests.clients.gcore.box_api.V1CreateRegistryRequest() # V1CreateRegistryRequest | Registry configuration

    try:
        # Create container registry
        api_response = api_instance.v1_create_registry(project_name, v1_create_registry_request)
        print("The response of RegistriesApi->v1_create_registry:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling RegistriesApi->v1_create_registry: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 
 **v1_create_registry_request** | [**V1CreateRegistryRequest**](V1CreateRegistryRequest.md)| Registry configuration | 

### Return type

[**ApiServicesRegistriesV1RegistryResponse**](ApiServicesRegistriesV1RegistryResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_delete_registry**
> v1_delete_registry(project_name, registry_name)

Delete container registry

Deletes a container registry from the specified project.

This operation permanently removes the registry and all its images, users, and associated resources.
All data stored in the registry will be lost. This action cannot be undone, so use it with caution.
Make sure to back up any important images before deleting the registry.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.RegistriesApi(api_client)
    project_name = 'project_name_example' # str | Project name
    registry_name = 'registry_name_example' # str | Registry name

    try:
        # Delete container registry
        api_instance.v1_delete_registry(project_name, registry_name)
    except Exception as e:
        print("Exception when calling RegistriesApi->v1_delete_registry: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 
 **registry_name** | **str**| Registry name | 

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_delete_registry_image**
> v1_delete_registry_image(project_name, registry_name, image_name)

Delete registry image

Deletes a specific image from the container registry.

This operation permanently removes the specified image and all its tags from the registry.
This action cannot be undone, so use it with caution. Make sure the image is not being used
by any running containers or deployments before deleting it. This operation helps free up
storage space in your registry.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.RegistriesApi(api_client)
    project_name = 'project_name_example' # str | Project name
    registry_name = 'registry_name_example' # str | Registry name
    image_name = 'image_name_example' # str | Image name

    try:
        # Delete registry image
        api_instance.v1_delete_registry_image(project_name, registry_name, image_name)
    except Exception as e:
        print("Exception when calling RegistriesApi->v1_delete_registry_image: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 
 **registry_name** | **str**| Registry name | 
 **image_name** | **str**| Image name | 

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_get_registry**
> ApiServicesRegistriesV1RegistryResponse v1_get_registry(project_name, registry_name)

Get container registry

Returns detailed information about a specific container registry in the project.

This endpoint provides comprehensive details about the registry, including its status,
URL, storage limit, public/private status, and preheat policies.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.api_services_registries_v1_registry_response import ApiServicesRegistriesV1RegistryResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.RegistriesApi(api_client)
    project_name = 'project_name_example' # str | Project name
    registry_name = 'registry_name_example' # str | Registry name

    try:
        # Get container registry
        api_response = api_instance.v1_get_registry(project_name, registry_name)
        print("The response of RegistriesApi->v1_get_registry:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling RegistriesApi->v1_get_registry: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 
 **registry_name** | **str**| Registry name | 

### Return type

[**ApiServicesRegistriesV1RegistryResponse**](ApiServicesRegistriesV1RegistryResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_list_registries**
> V1ListRegistryResponse v1_list_registries(project_name)

List container registries

Returns a list of all container registries in the specified project.

This endpoint provides a summary of all container registries, including their names,
status, URLs, storage limits, public/private status, and preheat policies.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_list_registry_response import V1ListRegistryResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.RegistriesApi(api_client)
    project_name = 'project_name_example' # str | Project name

    try:
        # List container registries
        api_response = api_instance.v1_list_registries(project_name)
        print("The response of RegistriesApi->v1_list_registries:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling RegistriesApi->v1_list_registries: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 

### Return type

[**V1ListRegistryResponse**](V1ListRegistryResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_list_registry_images**
> V1ListImagesResponse v1_list_registry_images(project_name, registry_name)

List registry images

Returns a list of all images stored in the specified container registry.

This endpoint provides information about all images in the registry, including
their names, tags, sizes, repositories, and display names. You can use this information
to manage your container images, track storage usage, and identify images that can be
pruned to free up space.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_list_images_response import V1ListImagesResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.RegistriesApi(api_client)
    project_name = 'project_name_example' # str | Project name
    registry_name = 'registry_name_example' # str | Registry name

    try:
        # List registry images
        api_response = api_instance.v1_list_registry_images(project_name, registry_name)
        print("The response of RegistriesApi->v1_list_registry_images:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling RegistriesApi->v1_list_registry_images: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 
 **registry_name** | **str**| Registry name | 

### Return type

[**V1ListImagesResponse**](V1ListImagesResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_update_registry**
> ApiServicesRegistriesV1RegistryResponse v1_update_registry(project_name, registry_name, v1_update_registry_request)

Update container registry

Updates an existing container registry in the specified project.

This endpoint allows you to modify the registry's configuration, including
its public/private status, storage limit, and preheat policies. You can use this
to change access permissions, increase storage capacity, or configure automated
image preheating for faster image pulls.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.api_services_registries_v1_registry_response import ApiServicesRegistriesV1RegistryResponse
from si_tests.clients.gcore.box_api.models.v1_update_registry_request import V1UpdateRegistryRequest
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.RegistriesApi(api_client)
    project_name = 'project_name_example' # str | Project name
    registry_name = 'registry_name_example' # str | Registry name
    v1_update_registry_request = si_tests.clients.gcore.box_api.V1UpdateRegistryRequest() # V1UpdateRegistryRequest | Updated registry configuration

    try:
        # Update container registry
        api_response = api_instance.v1_update_registry(project_name, registry_name, v1_update_registry_request)
        print("The response of RegistriesApi->v1_update_registry:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling RegistriesApi->v1_update_registry: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **project_name** | **str**| Project name | 
 **registry_name** | **str**| Registry name | 
 **v1_update_registry_request** | [**V1UpdateRegistryRequest**](V1UpdateRegistryRequest.md)| Updated registry configuration | 

### Return type

[**ApiServicesRegistriesV1RegistryResponse**](ApiServicesRegistriesV1RegistryResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

