# si_tests.clients.gcore.box_api.NodesApi

All URIs are relative to *http://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**v1_list_gpu_nodes**](NodesApi.md#v1_list_gpu_nodes) | **GET** /v1/admin/nodes | List gpu nodes
[**v1_perform_node_action**](NodesApi.md#v1_perform_node_action) | **POST** /v1/admin/nodes/action | Action perform action on the nodes.


# **v1_list_gpu_nodes**
> V1NodeListResponse v1_list_gpu_nodes()

List gpu nodes

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_node_list_response import V1NodeListResponse
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.NodesApi(api_client)

    try:
        # List gpu nodes
        api_response = api_instance.v1_list_gpu_nodes()
        print("The response of NodesApi->v1_list_gpu_nodes:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling NodesApi->v1_list_gpu_nodes: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**V1NodeListResponse**](V1NodeListResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | OK |  -  |
**404** | Not Found |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **v1_perform_node_action**
> v1_perform_node_action(v1_action_requests)

Action perform action on the nodes.

Perform an action on the nodes, possible actions are "cordon", "uncordon", "drain", "undrain".
The action is performed on the nodes specified in the request body, grouped by region.

The action can be one of the following:
- cordon - marks the nodes as unschedulable, preventing new inferences from being scheduled on them.
- uncordon - marks the nodes as schedulable, allowing new inferences to be scheduled on them.
- drain - safely evicts all inferences from the nodes, ensuring that they are gracefully terminated.
- undrain - reverses the drain action, allowing inferences to be scheduled on the nodes again.

### Example


```python
import si_tests.clients.gcore.box_api
from si_tests.clients.gcore.box_api.models.v1_action_requests import V1ActionRequests
from si_tests.clients.gcore.box_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = si_tests.clients.gcore.box_api.Configuration(
    host = "http://localhost"
)


# Enter a context with an instance of the API client
with si_tests.clients.gcore.box_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = si_tests.clients.gcore.box_api.NodesApi(api_client)
    v1_action_requests = si_tests.clients.gcore.box_api.V1ActionRequests() # V1ActionRequests | Action body

    try:
        # Action perform action on the nodes.
        api_instance.v1_perform_node_action(v1_action_requests)
    except Exception as e:
        print("Exception when calling NodesApi->v1_perform_node_action: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **v1_action_requests** | [**V1ActionRequests**](V1ActionRequests.md)| Action body | 

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | No Content |  -  |
**400** | Bad Request |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

